#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.container.constraints import containers, contains

from pyams_content.reference.interfaces import IReferenceInfo, IReferenceTable
from pyams_i18n.schema import I18nTextLineField

__docformat__ = 'restructuredtext'

from onf_website import _


class ITarget(IReferenceInfo):
    """Target interface"""

    containers('.ITargetTable')

    facets_label = I18nTextLineField(title=_("Facets label"),
                                     description=_("Label used for search engine facets, instead of default label"),
                                     required=False)


class ITargetTable(IReferenceTable):
    """Target table interface"""

    contains(ITarget)
