
"""ONF_website module

"""

from z3c.form.field import Fields
from zope.interface import implementer

from onf_website.reference.planning import IPlanningTable
from onf_website.reference.planning.zmi.widget import PlanningTableDisplaysSelectWidgetFactory
from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION
from pyams_content.reference.zmi.table import ReferenceTablePropertiesMenu
from pyams_form.form import ajax_config
from pyams_form.group import NamedWidgetsGroup
from pyams_form.interfaces.form import IInnerSubForm, IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IInnerPage
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm, InnerAdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'

from onf_website import _


@viewlet_config(name='properties.menu',
                context=IPlanningTable, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=10,
                permission=VIEW_SYSTEM_PERMISSION)
class PlanningTablePropertiesMenu(ReferenceTablePropertiesMenu):
    """Planning table properties menu"""

    url = '#properties.html'
    modal_target = False


@pagelet_config(name='properties.html',
                context=IPlanningTable, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json',
             context=IPlanningTable, layer=IPyAMSLayer)
@implementer(IWidgetForm, IInnerPage)
class PlanningTablePropertiesEditForm(AdminEditForm):
    """Planning table properties edit form"""

    prefix = 'table_properties.'

    legend = _("Edit table properties")

    fields = Fields(IPlanningTable).select('title', 'short_name')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION


@adapter_config(name='displays-settings',
                context=(IPlanningTable, IPyAMSLayer, PlanningTablePropertiesEditForm),
                provides=IInnerSubForm)
class PlanningTableDisplaysSettingsEditForm(InnerAdminEditForm):
    """Planning table displays settings edit form"""

    prefix = 'display_properties.'

    legend = _("Display settings")
    fieldset_class = 'bordered no-x-margin margin-y-10'

    fields = Fields(IPlanningTable).select('planning_displays')
    fields['planning_displays'].widgetFactory = PlanningTableDisplaysSelectWidgetFactory

    weight = 2

    def updateGroups(self):
        self.add_group(NamedWidgetsGroup(self, 'displays', self.widgets,
                                         ('planning_displays',),
                                         fieldset_class='inner bordered',
                                         switch=False))
