"""PyAMS_*** module

"""

from zope.interface import Attribute
from zope.schema import Bool, Choice, Dict

from onf_website.reference.forest.interfaces import FOREST_OWNERS_CATEGORIES
from pyams_content.reference import IReferenceTable


__docformat__ = 'restructuredtext'

from onf_website import _


class IPlanningTable(IReferenceTable):
    """Planning table manager interface"""

    planning_displays = Dict(title=_("Planning displays"),
                             description=_(
                                 "You can disable display of all plannings for a specific "
                                 "owner category by just unchecking their label"),
                             key_type=Choice(vocabulary=FOREST_OWNERS_CATEGORIES),
                             value_type=Bool(required=True,
                                             default=True),
                             required=False)

    visible_owners_ids = Attribute("Visible owners categories IDs")
