#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from pyramid_rpc.jsonrpc import jsonrpc_method

from onf_website.reference.orga.model import Structure


@jsonrpc_method(endpoint='onf_website')
def findStructures(request, query, structure_type=None, category_code=None):
    """Structures search service"""
    params = {
        'query': query
    }
    if structure_type:
        params['type'] = structure_type
    if category_code:
        params['category'] = category_code
    return [
        {
            'id': structure.token,
            'text': structure.title
        }
        for structure in Structure.find(params).order_by(Structure.code_sign)
    ]
