
-- Table: refstruct.vm_bu_structures

CREATE TABLE refstruct.vm_bu_structures
(
   id                               bigint                          NOT NULL,
   code                             character(6)                         NOT NULL,
   code_sign                        character varying(6)                     ,
   libelle                          character varying(50)                    ,
   libelle_long                     character varying(100)                   ,
   niveau                           numeric                          NOT NULL,
   libelle_type                     character varying(20)                    NOT NULL,
   libelle_long_type                character varying(200)                   ,
   d_debut                          DATE                            NOT NULL,
   d_fin                            DATE                            ,
   etat                             DATE                            ,
   libelle_parent                   character varying(50)                    ,
   code_parent                      character(6)                         ,
   code_cc                          character(6)                         ,
   libelle_cc                       character varying(40)                    ,
   site_libelle                     character varying(20)                    ,
   adresse_comp                     character varying(50)                    ,
   num_voie                         numeric(4)                       ,
   ext_voie                         character varying(5)                     ,
   nat_voie                         character varying(44)                    ,
   nom_commune                      character varying(50)                    ,
   code_commune                     character(5)                         ,
   code_postal                      character varying(5)                     ,
   bur_distrib                      character varying(32)                    ,
   pays                             character(6)                         ,
   pays_code_iso                    character(2)                         ,
   code_soc                         character varying(4000)                  ,
   libelle_soc                      character varying(4000)                  ,
   code_etab                        character varying(4000)                  ,
   libelle_etab                     character varying(4000)                  ,
   code_dir_ag                      character varying(4000)                  ,
   code_sign_dir_ag                 character varying(4000)                  ,
   libelle_dir_ag                   character varying(4000)                  ,
   code_sign_dt_dir                 character varying(4)                     ,
   code_service                     character varying(4000)                  ,
   code_pole                        character varying(4000)                  ,
   libelle_categorie                character varying(100)                   ,
   code_categorie                   character varying(10),
   CONSTRAINT vm_bustructures_pkey  PRIMARY KEY (id)
);


-- Index: refstruct.idx_structure_codesign

CREATE INDEX idx_structure_codesign
  ON refstruct.vm_bu_structures
  USING btree
  (code_sign COLLATE pg_catalog."default");
