#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface
from zope.schema import Date, Int, TextLine

from onf_website import _


class IStructure(Interface):
    """ONF structure interface"""

    id = Int(title=_("Internal ID"))
    code = TextLine(title=_("Internal code"), max_length=6)
    code_sign = TextLine(title=_("Significant code"), max_length=6)
    libelle = TextLine(title=_("Label"), max_length=30)
    libelle_long = TextLine(title=_("Long label"), max_length=40)
    libelle_type = TextLine(title=_("Type label"), max_length=20)
    libelle_type_long = TextLine(title=_("Type long label"), max_length=40)
    date_debut = Date(title=_("Validity start date"))
    date_fin = Date(title=_("Validity end date"))
    date_etat = Date(title=_("State date"))
    code_parent = TextLine(title=_("Parent code"), max_length=6)
    complement_adresse = TextLine(title=_("Address complement"), max_length=40)
    num_voie = Int(title=_("Street number"))
    ext_voie = TextLine(title=_("Street number extension"), max_length=5)
    nature_voie = TextLine(title=_("Street"), max_length=32)
    nom_commune = TextLine(title=_("Commune name"), max_length=32)
    code_commune = TextLine(title=_("Commune INSEE code"), max_length=5)
    code_postal = TextLine(title=_("Postal code"), max_length=10)
    bureau_distrib = TextLine(title=_("Distribution desk"), max_length=32)
    pays = TextLine(title=_("Country"), max_length=6)
    code_iso_pays = TextLine(title=_("ISO country code"), max_length=2)

    def get_parents(self, fields=None, session=None):
        """Get structure parents

        :param tuple fields: tuple of fields to get from parents; if None, results are Structure objects
        :param str session: an SQLAlchemy engine name or already created session
        """

    def get_children(self, fields, session, category=None, direct_only=False, reference_date=None):
        """Get structure children

        :param tuple fields: tuple of fields to get from children; if None, results are Structure objects
        :param str session: an SQLAlchemy engine name, or an already created session
        :param bool category: if True, only structures of this category will be retrieved
        :param bool direct_only: if True, only direct child structures of parent will be retrieved
        :param date reference_date: defines the date at which structures must be active; if None,
            selected date is the current date
        """


class IStructureModel(Interface):
    """Structure model marker interface"""
