#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from onf_website.reference.location.interfaces.department import IDepartmentTable, IDepartment
from pyams_content.interfaces import MANAGE_SITE_ROOT_PERMISSION
from pyams_skin.interfaces.viewlet import IWidgetTitleViewletManager
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_zmi.layer import IAdminLayer

# import packages
from onf_website.reference.location.department import Department
from pyams_content.reference.zmi import ReferenceInfoAJAXEditForm
from pyams_content.reference.zmi.table import ReferenceTableContentsTable
from pyams_form.form import AJAXAddForm, ajax_config
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.viewlet.toolbar import ToolbarAction
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminDialogAddForm, AdminDialogEditForm
from z3c.form import field

from onf_website import _


@viewlet_config(name='add-department.action', context=IDepartmentTable, layer=IAdminLayer,
                manager=IWidgetTitleViewletManager, view=ReferenceTableContentsTable,
                permission=MANAGE_SITE_ROOT_PERMISSION)
class DepartmentAddAction(ToolbarAction):
    """Department add action"""

    label = _("Add department")

    url = 'add-department.html'
    modal_target = True


@pagelet_config(name='add-department.html', context=IDepartmentTable, layer=IPyAMSLayer,
                permission=MANAGE_SITE_ROOT_PERMISSION)
@ajax_config(name='add-department.json', context=IDepartmentTable, layer=IPyAMSLayer, base=AJAXAddForm)
class DepartmentAddForm(AdminDialogAddForm):
    """Department add form"""

    legend = _("Adding new department")

    fields = field.Fields(IDepartment).omit('__parent__')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION

    def create(self, data):
        return Department()

    def add(self, object):
        self.context[object.__name__] = object

    def nextURL(self):
        return 'contents.html'


@pagelet_config(name='properties.html', context=IDepartment, layer=IPyAMSLayer, permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='properties.json', context=IDepartment, layer=IPyAMSLayer, base=ReferenceInfoAJAXEditForm)
class DepartmentEditForm(AdminDialogEditForm):
    """Department edit form"""

    prefix = 'department_properties.'

    legend = _("Edit department properties")

    fields = field.Fields(IDepartment).omit('__parent__', '__name__')
    edit_permission = MANAGE_SITE_ROOT_PERMISSION
