#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.reference.interfaces import IReferenceTable
from onf_website.reference.location.interfaces import IBaseLocationInfo

# import packages
from zope.container.constraints import contains, containers
from zope.schema import TextLine

from onf_website import _


class ICountry(IBaseLocationInfo):
    """Country interface"""

    containers('.ICountryTable')

    insee_code = TextLine(title=_("INSEE code"),
                          required=False)


class ICountryTable(IReferenceTable):
    """Countries table"""

    contains(ICountry)
