#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces
from pyams_content.reference.interfaces import IReferenceInfo, IReferenceTable

# import packages
from zope.container.constraints import contains, containers
from zope.schema import TextLine, List, Choice

from onf_website import _


class IAgency(IReferenceInfo):
    """Agency interface"""

    containers('.IAgencyTable')

    internal_code = TextLine(title=_("Internal code"),
                             required=False)

    territory = Choice(title=_("Territory"),
                       vocabulary='ONF territories',
                       required=False)

    departments = List(title=_("Departments"),
                       value_type=Choice(vocabulary='ONF departments'),
                       required=False)


class IAgencyTable(IReferenceTable):
    """Agencies table"""

    contains(IAgency)
