#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pyramid_rpc.jsonrpc import jsonrpc_method

from onf_website.reference.insee.model import Commune, Departement


__docformat__ = 'restructuredtext'


@jsonrpc_method(endpoint='onf_website', require_csrf=False)
def findDepartments(request, query):
    return [{
        'id': department.token,
        'text': department.title
    } for department in Departement.find(query).order_by(Departement.dep)]


@jsonrpc_method(endpoint='onf_website', require_csrf=False)
def findCommunes(request, query):
    return [{
        'id': commune.token,
        'text': commune.title
    } for commune in Commune.find(query).order_by(Commune.nccenr)]
