
-- Table: insee.insee_code_cdc

CREATE TABLE insee.insee_code_cdc
(
  id bigint NOT NULL,
  code character varying(1) NOT NULL, -- Code référencé
  libelle character varying(50) NOT NULL, -- Libellé
  CONSTRAINT insee_code_cdc_pkey PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_code_cdc OWNER TO pgadm;
COMMENT ON TABLE insee.insee_code_cdc IS 'Découpages des communes en cantons';
COMMENT ON COLUMN insee.insee_code_cdc.code IS 'Code référencé';
COMMENT ON COLUMN insee.insee_code_cdc.libelle IS 'Libellé';


-- Table: insee.insee_code_tncc

CREATE TABLE insee.insee_code_tncc
(
  id bigint NOT NULL,
  code character varying(1) NOT NULL, -- Code référencé
  libelle character varying(50) NOT NULL, -- Libellé
  CONSTRAINT insee_code_tncc_pkey PRIMARY KEY (id),
  CONSTRAINT insee_code_tncc_code_key UNIQUE (code)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_code_tncc OWNER TO pgadm;
COMMENT ON TABLE insee.insee_code_tncc IS 'Définition des types de nom en clair. Utiliser lorsque l''on veut nommer. La commune >>de<< PARIS, par exemple';
COMMENT ON COLUMN insee.insee_code_tncc.code IS 'Code référencé';
COMMENT ON COLUMN insee.insee_code_tncc.libelle IS 'Libellé';


-- Table: insee.insee_code_typct

CREATE TABLE insee.insee_code_typct
(
  id bigint NOT NULL,
  code character varying(1) NOT NULL, -- Code référencé
  libelle character varying(100) NOT NULL, -- Libellé
  CONSTRAINT insee_code_typct_pkey PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_code_typct OWNER TO pgadm;
COMMENT ON TABLE insee.insee_code_typct IS 'Défintion des compositions communales du Canton';
COMMENT ON COLUMN insee.insee_code_typct.code IS 'Code référencé';
COMMENT ON COLUMN insee.insee_code_typct.libelle IS 'Libellé';


-- Table: insee.insee_code_cheflieu

CREATE TABLE insee.insee_code_cheflieu
(
  id bigint NOT NULL,
  code character varying(1) NOT NULL, -- Code référencé
  libelle character varying(50) NOT NULL, -- Libellé
  CONSTRAINT insee_code_cheflieu_pkey PRIMARY KEY (id),
  CONSTRAINT insee_code_cheflieu_code_key UNIQUE (code)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_code_cheflieu OWNER TO pgadm;
COMMENT ON TABLE insee.insee_code_cheflieu IS 'Type de chef lieu';
COMMENT ON COLUMN insee.insee_code_cheflieu.code IS 'Code référencé';
COMMENT ON COLUMN insee.insee_code_cheflieu.libelle IS 'Libellé';


-- Table: insee.insee_pays

CREATE TABLE insee.insee_pays
(
  id bigint NOT NULL,
  cog character varying(5) NOT NULL, -- Code du pays ou territoire
  actual character varying(1), -- Code actualité du pays
  capay character varying(5), -- Code officiel géographique de l ancien pays de rattachement
  crpay character varying(5), -- Code officiel géographique de l actuel pays de rattachement
  ani character varying(4), -- Année d indépendance
  libcog character varying(70), -- Libellé utilisé dans le C.O.G.
  libenr character varying(70), -- Libellé du nom entier développé et enrichi paru au J.O. du 25 janvier 1994
  ancnom character varying(20), -- Ancien nom du pays
  code_iso character varying(2), -- Code du pays selon la norme ISO 3166
  CONSTRAINT insee_pays_pkey PRIMARY KEY (id),
  CONSTRAINT insee_pays_code_iso_key UNIQUE (code_iso)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_pays OWNER TO pgadm;
COMMENT ON TABLE insee.insee_pays IS 'Le fichier 2011 des pays et territoires étrangers contient le code des pays, le libellé, leur année d indépendance, leur ancien nom, leur ancien code, leur code pays de rattachement si nécessaire.';
COMMENT ON COLUMN insee.insee_pays.cog IS 'Code du pays ou territoire';
COMMENT ON COLUMN insee.insee_pays.actual IS 'Code actualité du pays';
COMMENT ON COLUMN insee.insee_pays.capay IS 'Code officiel géographique de l ancien pays de rattachement';
COMMENT ON COLUMN insee.insee_pays.crpay IS 'Code officiel géographique de l actuel pays de rattachement';
COMMENT ON COLUMN insee.insee_pays.ani IS 'Année d indépendance';
COMMENT ON COLUMN insee.insee_pays.libcog IS 'Libellé utilisé dans le C.O.G.';
COMMENT ON COLUMN insee.insee_pays.libenr IS 'Libellé du nom entier développé et enrichi paru au J.O. du 25 janvier 1994';
COMMENT ON COLUMN insee.insee_pays.ancnom IS 'Ancien nom du pays';
COMMENT ON COLUMN insee.insee_pays.code_iso IS 'Code du pays selon la norme ISO 3166';


-- Table: insee.insee_region

CREATE TABLE insee.insee_region
(
  id bigint NOT NULL,
  region character varying(2), -- Code région
  cheflieu character varying(5), -- Code de la commune chef-lieu
  tncc character varying(1), -- Type de nom en clair
  ncc character varying(70), -- Libellé en lettres majuscules
  nccenr character varying(70), -- Libellé enrichi
  CONSTRAINT insee_region_pkey PRIMARY KEY (id),
  CONSTRAINT insee_region_region_key UNIQUE (region)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_region OWNER TO pgadm;
COMMENT ON TABLE insee.insee_region IS 'Dessin du fichier région.';
COMMENT ON COLUMN insee.insee_region.region IS 'Code région';
COMMENT ON COLUMN insee.insee_region.cheflieu IS 'Code de la commune chef-lieu';
COMMENT ON COLUMN insee.insee_region.tncc IS 'Type de nom en clair';
COMMENT ON COLUMN insee.insee_region.ncc IS 'Libellé en lettres majuscules';
COMMENT ON COLUMN insee.insee_region.nccenr IS 'Libellé enrichi';


-- Table: insee.insee_departement

CREATE TABLE insee.insee_departement
(
  id bigint NOT NULL,
  region character varying(2), -- Code région
  dep character varying(3), -- Code département
  cheflieu character varying(5), -- Code de la commune chef-lieu
  tncc character varying(1), -- Type de nom en clair
  ncc character varying(70), -- Libellé en lettres majuscules
  nccenr character varying(70), -- Libellé enrichi
  CONSTRAINT insee_departement_pkey PRIMARY KEY (id),
  CONSTRAINT fk_inseedepregion FOREIGN KEY (region)
      REFERENCES insee.insee_region (region) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT insee_departement_dep_key UNIQUE (dep)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_departement OWNER TO pgadm;
COMMENT ON TABLE insee.insee_departement IS 'Dessin du fichier départements.';
COMMENT ON COLUMN insee.insee_departement.region IS 'Code région';
COMMENT ON COLUMN insee.insee_departement.dep IS 'Code département';
COMMENT ON COLUMN insee.insee_departement.cheflieu IS 'Code de la commune chef-lieu';
COMMENT ON COLUMN insee.insee_departement.tncc IS 'Type de nom en clair';
COMMENT ON COLUMN insee.insee_departement.ncc IS 'Libellé en lettres majuscules';
COMMENT ON COLUMN insee.insee_departement.nccenr IS 'Libellé enrichi';


-- Index: insee.idx_inseedepartement_region

CREATE INDEX idx_inseedepartement_region
  ON insee.insee_departement
  USING btree
  (region COLLATE pg_catalog."default");


-- Table: insee.insee_arrondissement

CREATE TABLE insee.insee_arrondissement
(
  id bigint NOT NULL,
  region character varying(2), -- Code région
  dep character varying(3), -- Code département
  ar character varying(1), -- Code arrondissement
  cheflieu character varying(5), -- Code de la commune chef-lieu
  tncc character varying(1), -- Type de nom en clair
  artmaj character varying(5), -- Article en majuscules
  ncc character varying(70), -- Libellé en lettres majuscules
  artmin character varying(5), -- Article enrichi
  nccenr character varying(70), -- Libellé enrichi
  CONSTRAINT insee_arrondissement_pkey PRIMARY KEY (id),
  CONSTRAINT fk_inseearronddep FOREIGN KEY (dep)
      REFERENCES insee.insee_departement (dep) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT fk_inseearrondregion FOREIGN KEY (region)
      REFERENCES insee.insee_region (region) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT insee_arrondissement_dep_ar_key UNIQUE (dep, ar)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_arrondissement OWNER TO pgadm;
COMMENT ON TABLE insee.insee_arrondissement IS 'Dessin du fichier Arrondissements.';
COMMENT ON COLUMN insee.insee_arrondissement.region IS 'Code région';
COMMENT ON COLUMN insee.insee_arrondissement.dep IS 'Code département';
COMMENT ON COLUMN insee.insee_arrondissement.ar IS 'Code arrondissement';
COMMENT ON COLUMN insee.insee_arrondissement.cheflieu IS 'Code de la commune chef-lieu';
COMMENT ON COLUMN insee.insee_arrondissement.tncc IS 'Type de nom en clair';
COMMENT ON COLUMN insee.insee_arrondissement.artmaj IS 'Article en majuscules';
COMMENT ON COLUMN insee.insee_arrondissement.ncc IS 'Libellé en lettres majuscules';
COMMENT ON COLUMN insee.insee_arrondissement.artmin IS 'Article enrichi';
COMMENT ON COLUMN insee.insee_arrondissement.nccenr IS 'Libellé enrichi';


-- Index: insee.idx_inseearrondissement_dep

CREATE INDEX idx_inseearrondissement_dep
  ON insee.insee_arrondissement
  USING btree
  (dep COLLATE pg_catalog."default");


-- Index: insee.idx_inseearrondissement_region

CREATE INDEX idx_inseearrondissement_region
  ON insee.insee_arrondissement
  USING btree
  (region COLLATE pg_catalog."default");


-- Table : insee.insee_canton

CREATE TABLE insee.insee_canton
(
  id bigint NOT NULL,
  region character varying(2), -- Code région
  dep character varying(3), -- Code département
  ar character varying(2), -- Code arrondissement
  canton character varying(2), -- Code canton
  typct character varying(1), -- Composition communale du canton
  cheflieu character varying(5), -- Code de la commune chef-lieu
  tncc character varying(1), -- Type de nom en clair
  artmaj character varying(5), -- Article en majuscules
  ncc character varying(70), -- Libellé en lettres majuscules
  artmin character varying(5), -- Article enrichi
  nccenr character varying(70), -- Libellé enrichi
  CONSTRAINT insee_canton_pkey PRIMARY KEY (id),
  CONSTRAINT fk_inseecantonarrond FOREIGN KEY (dep, ar)
      REFERENCES insee.insee_arrondissement (dep, ar) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT fk_inseecantondep FOREIGN KEY (dep)
      REFERENCES insee.insee_departement (dep) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT fk_inseecantonregion FOREIGN KEY (region)
      REFERENCES insee.insee_region (region) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE CASCADE,
  CONSTRAINT insee_canton_dep_ar_canton_key UNIQUE (dep, ar, canton)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_canton OWNER TO pgadm;
COMMENT ON TABLE insee.insee_canton IS 'Dessin du fichier Cantons.';
COMMENT ON COLUMN insee.insee_canton.region IS 'Code région';
COMMENT ON COLUMN insee.insee_canton.dep IS 'Code département';
COMMENT ON COLUMN insee.insee_canton.ar IS 'Code arrondissement';
COMMENT ON COLUMN insee.insee_canton.canton IS 'Code canton';
COMMENT ON COLUMN insee.insee_canton.typct IS 'Composition communale du canton';
COMMENT ON COLUMN insee.insee_canton.cheflieu IS 'Code de la commune chef-lieu';
COMMENT ON COLUMN insee.insee_canton.tncc IS 'Type de nom en clair';
COMMENT ON COLUMN insee.insee_canton.artmaj IS 'Article en majuscules';
COMMENT ON COLUMN insee.insee_canton.ncc IS 'Libellé en lettres majuscules';
COMMENT ON COLUMN insee.insee_canton.artmin IS 'Article enrichi';
COMMENT ON COLUMN insee.insee_canton.nccenr IS 'Libellé enrichi';


-- Index: insee.idx_inseecanton_dep

CREATE INDEX idx_inseecanton_dep
  ON insee.insee_canton
  USING btree
  (dep COLLATE pg_catalog."default");


-- Index: insee.idx_inseecanton_depar

CREATE INDEX idx_inseecanton_depar
  ON insee.insee_canton
  USING btree
  (dep COLLATE pg_catalog."default", ar COLLATE pg_catalog."default");


-- Index: insee.idx_inseecanton_region

CREATE INDEX idx_inseecanton_region
  ON insee.insee_canton
  USING btree
  (region COLLATE pg_catalog."default");


-- Table: insee.insee_commune

CREATE TABLE insee.insee_commune
(
  cdc character varying(1), -- Découpage de la commune en cantons
  cheflieu character varying(1), -- Chef-lieu de canton, d arrondissement, de département, de région
  reg character varying(2), -- Code région
  dep character varying(3), -- Code département
  com character varying(3), -- Code commune
  ar character varying(1), -- Code arrondissement
  ct character varying(2), -- Code canton
  tncc character varying(1), -- Type de nom en clair
  artmaj character varying(5), -- Article (majuscules)
  ncc character varying(70), -- Nom en clair (majuscules)
  artmin character varying(5), -- Article (typographie riche)
  nccenr character varying(70), -- Nom en clair (typographie riche)
  code character varying(5), -- Code Insee (ajoutée par ONF)
  id bigint NOT NULL,
  CONSTRAINT insee_commune_pkey PRIMARY KEY (id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.insee_commune OWNER TO pgadm;
COMMENT ON TABLE insee.insee_commune IS 'Ensemble des communes existantes';
COMMENT ON COLUMN insee.insee_commune.cdc IS 'Découpage de la commune en cantons';
COMMENT ON COLUMN insee.insee_commune.cheflieu IS 'Chef-lieu de canton, d arrondissement, de département, de région';
COMMENT ON COLUMN insee.insee_commune.reg IS 'Code région';
COMMENT ON COLUMN insee.insee_commune.dep IS 'Code département';
COMMENT ON COLUMN insee.insee_commune.com IS 'Code commune';
COMMENT ON COLUMN insee.insee_commune.ar IS 'Code arrondissement';
COMMENT ON COLUMN insee.insee_commune.ct IS 'Code canton';
COMMENT ON COLUMN insee.insee_commune.tncc IS 'Type de nom en clair';
COMMENT ON COLUMN insee.insee_commune.artmaj IS 'Article (majuscules)';
COMMENT ON COLUMN insee.insee_commune.ncc IS 'Nom en clair (majuscules)';
COMMENT ON COLUMN insee.insee_commune.artmin IS 'Article (typographie riche)';
COMMENT ON COLUMN insee.insee_commune.nccenr IS 'Nom en clair (typographie riche)';
COMMENT ON COLUMN insee.insee_commune.code IS 'Code Insee (ajoutée par ONF)';


-- Index: insee.idx_inseecommune_code

CREATE INDEX idx_inseecommune_code
  ON insee.insee_commune
  USING btree
  (code COLLATE pg_catalog."default");


-- Table: insee.hexaposte

CREATE TABLE insee.hexaposte
(
  id bigint NOT NULL,
  codeinsee character varying(5), -- Code INSEE de la localité ou du Bureau Distributeur
  reserve character varying(1), -- Particularité de Distribution
  libelle character varying(38), -- Libellé de la localité
  codepostal character varying(5), -- Code postal ou CEDEX
  distributeur character varying(1), -- Indicateur bureau distributeur
  libellecedex character varying(26), -- Libellé de la ligne acheminement
  filler character varying(5), -- Filler
  CONSTRAINT hexaposte_pkey PRIMARY KEY (id),
  CONSTRAINT hexaposte_codeinsee_codepostal_key UNIQUE (codeinsee, codepostal)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE insee.hexaposte OWNER TO pgadm;
COMMENT ON TABLE insee.hexaposte IS 'Fichier 2011 HEXAPOSTE';
COMMENT ON COLUMN insee.hexaposte.codeinsee IS 'Code INSEE de la localité ou du Bureau Distributeur';
COMMENT ON COLUMN insee.hexaposte.reserve IS 'Particularité de Distribution';
COMMENT ON COLUMN insee.hexaposte.libelle IS 'Libellé de la localité';
COMMENT ON COLUMN insee.hexaposte.codepostal IS 'Code postal ou CEDEX';
COMMENT ON COLUMN insee.hexaposte.distributeur IS 'Indicateur bureau distributeur';
COMMENT ON COLUMN insee.hexaposte.libellecedex IS 'Libellé de la ligne acheminement';
COMMENT ON COLUMN insee.hexaposte.filler IS 'Filler';


-- Index: insee.idx_hexaposte_codeinsee

CREATE INDEX idx_hexaposte_codeinsee
  ON insee.hexaposte
  USING btree
  (codeinsee COLLATE pg_catalog."default");


-- Index: insee.idx_hexaposte_codepostal

CREATE INDEX idx_hexaposte_codepostal
  ON insee.hexaposte
  USING btree
  (codepostal COLLATE pg_catalog."default");


-- Index: insee.idx_hexaposte_libelle

CREATE INDEX idx_hexaposte_libelle
  ON insee.hexaposte
  USING btree
  (libelle COLLATE pg_catalog."default");


-- Index: insee.idx_hexaposte_libellecedex

CREATE INDEX idx_hexaposte_libellecedex
  ON insee.hexaposte
  USING btree
  (libellecedex COLLATE pg_catalog."default");
