#
# Copyright (c) 2008-2019 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from onf_website.reference.insee.schema import CommuneField, DepartmentField
from pyams_content.shared.form.field import TextLineFieldFactory
from pyams_content.shared.form.interfaces import IFormFieldFactory
from pyams_i18n.interfaces import II18n
from pyams_utils.registry import utility_config


__docformat__ = 'restructuredtext'

from onf_website import _


@utility_config(name='department', provides=IFormFieldFactory)
class DepartmentFormFieldFactory(TextLineFieldFactory):
    """Department form field factory"""

    label = _("Department")
    weight = 103

    field_factory = DepartmentField

    def get_schema_field(self, field):
        i18n = II18n(field)
        result = self.field_factory(title=i18n.query_attribute('label'),
                                    description=i18n.query_attribute('description'),
                                    min_length=2,
                                    max_length=3,
                                    required=field.required,
                                    default=i18n.query_attribute('default'))
        result.__name__ = field.name
        return result


@utility_config(name='postal_code', provides=IFormFieldFactory)
class PostalCodeFormFieldFactory(TextLineFieldFactory):
    """Postal code form field factory"""

    label = _("Postal code")
    weight = 102

    field_factory = CommuneField

    def get_schema_field(self, field):
        i18n = II18n(field)
        result = self.field_factory(title=i18n.query_attribute('label'),
                                    description=i18n.query_attribute('description'),
                                    min_length=5,
                                    max_length=5,
                                    required=field.required,
                                    default=i18n.query_attribute('default'))
        result.__name__ = field.name
        return result
