
/**
 * Add geometry column for forests in SRID 3857 (WGS Web Mercator)
 */

select addGeometryColumn('rdf_public', 'rdf_foret_geom', 'geom_3857', 3857, 'MULTIPOLYGON', 2);

create index idx_rdf_foret_geom_3857 on rdf_public.rdf_foret_geom using gist (geom_3857);


create or replace function wgs_to_wgswm()
  returns trigger
as
$BODY$
  begin
    new.geom_3857 = public.ST_Transform(new.geom, 3857);
    return new;
  end;
$BODY$
  language plpgsql volatile
  cost 100;


create trigger trg_rdf_foret_geom_biu
  before insert or update on rdf_public.rdf_foret_geom
  for each row
  execute procedure wgs_to_wgswm();


begin;

update rdf_public.rdf_foret_geom set geom_3857=null;

commit;
