#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface

from onf_website.reference.annuaire.portlet import IDirectoryPortletSettings
from pyams_form.form import AJAXEditForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION

__docformat__ = 'restructuredtext'


@pagelet_config(name='properties.html',
                context=IDirectoryPortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class DirectoryPortletSettingsEditor(PortletSettingsEditor):
    """Directory portlet settings editor"""
    
    settings = IDirectoryPortletSettings


@adapter_config(name='properties.json', 
                context=(IDirectoryPortletSettings, IPyAMSLayer), 
                provides=IPagelet)
class DirectoryPortletSettingsAJAXEditor(AJAXEditForm, DirectoryPortletSettingsEditor):
    """Directory portlet settings editor, JSON renderer"""


@adapter_config(context=(Interface,IPyAMSLayer,Interface,IDirectoryPortletSettings), 
                provides=IPortletPreviewer)
@template_config(template='templates/directory-preview.pt',
                 layer=IPyAMSLayer)
class DirectoryPortletPreviewer(PortletPreviewer):
    """Directory portlet previewer"""
