#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from colander import MappingSchema, SchemaNode, SequenceSchema, String, drop

from pyams_utils.rest import BaseResponseSchema


class DirectoryQuerySchema(BaseResponseSchema) :
    """Directory query"""


class DirectoryGetterRequest(MappingSchema):
    """Directory getter request"""
    querystring = DirectoryQuerySchema()


class DirectoryAgentSchema(MappingSchema) :
    """Directory item schema"""
    agent_id = SchemaNode(String(),
                          description="Agent's ID",
                          missing=drop)
    agent_name = SchemaNode(String(), 
                            description="Agent's name", 
                            missing=drop)
    agent_phone = SchemaNode(String(), 
                             description="Agent's phone number",
                             missing='Non fourni')
    agent_email = SchemaNode(String(), 
                             description="Agent's email",
                             missing="Email inconnu")
    ut_dac_name = SchemaNode(String(), 
                             description="Territorial unit name",
                             missing=drop)


class DirectoryQueryResponse(BaseResponseSchema):
    """Directory response schema"""
    contact = DirectoryAgentSchema(description="Main contact",
                                   missing=drop)
    manager = DirectoryAgentSchema(description="Manager contact",
                                   missing=drop)


class DirectoryGetterResponse(MappingSchema):
    """Directory getter response"""   
    
    body = DirectoryQueryResponse()
