#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


# import standard library

# import interfaces

# import packages
from zope.interface import Interface
from zope.schema import TextLine, Int, Date, Object

from onf_website import _


class IAgent(Interface):
    """ONF agent interface"""

    matricule_bu = Int(title=_("BU matricule"))
    matricule_perso = TextLine(title=_("PERSO matricule"), max_length=5)
    ldap_username = TextLine(title=_("LDAP username"), max_length=32)
    date_entree = Date(title=_("Entry date"))
    date_sortie = Date(title=_("Exit date"))
    code_civilite = TextLine(title=_("Civility code"))
    nom = TextLine(title=_("Last name"), max_length=80)
    prenom = TextLine(title=_("First name"), max_length=40)
    code_structure = TextLine(title=_("Structure code"), max_length=6)
    statut = TextLine(title=_("Status code"), max_length=3)
    code_poste = TextLine(title=_("Position code"), max_length=8)
    complement_adresse = TextLine(title=_("Address complement"), max_length=38)
    num_voie = Int(title=_("Street number"))
    ext_voie = TextLine(title=_("Street number extension"), max_length=1)
    nature_voie = TextLine(title=_("Street"), max_length=32)
    nom_commune = TextLine(title=_("Commune name"), max_length=32)
    code_postal = TextLine(title=_("Postal code"), max_length=10)
    bureau_distrib = TextLine(title=_("Distribution desk"), max_length=32)
    pays = TextLine(title=_("Country"), max_length=38)
    telephone = TextLine(title=_("Phone number"), max_length=10)
    fax = TextLine(title=_("Fax number"), max_length=10)
    mobile = TextLine(title=_("Mobile phone number"), max_length=10)
    mail = TextLine(title=_("Mail address"), max_length=100)
    matricule_manager = Int(title=_("Manager matricule number"))
    manager = Object(title=_("Manager"), schema=Interface, required=False)
    code_metier = TextLine(title=_("Job code"), max_length=50)

    def get_structure(self, reference_date, session):
        """Get agent's structure"""

IAgent['manager'].schema = IAgent
