#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation import IAnnotations

from onf_website.shared.view.skin import ONFViewItemsPortletNewsTightRendererSettings
from pyams_content.shared.view.portlet import VIEW_PORTLET_NAME
from pyams_portal.interfaces import IPortalContext, IPortalPortletsConfiguration, \
    IPortalTemplateContainer, PORTLET_RENDERER_SETTINGS_KEY
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, query_utility, set_local_registry
from pyams_utils.request import check_request


UPDATED_RENDERER_NAME = 'ONF::view.actus-tight'
RENDERER_SETTINGS_KEY = PORTLET_RENDERER_SETTINGS_KEY.format(UPDATED_RENDERER_NAME)


def evolve(site):
    """Evolve 1: rename annotations"""
    registry = get_local_registry()
    request = check_request()
    request.root = site
    try:
        set_local_registry(site.getSiteManager())
        # Update templates configuration
        templates = query_utility(IPortalTemplateContainer)
        if templates is not None:
            for template in templates.values():
                for portlet in IPortalPortletsConfiguration(template).values():
                    if portlet.portlet_name == VIEW_PORTLET_NAME:
                        if portlet.inherit_parent:
                            continue
                        settings = portlet.settings
                        if settings.renderer != UPDATED_RENDERER_NAME:
                            continue
                        print("Upgrading view items portlet settings in {}".format(template.name))
                        renderer_settings = IAnnotations(settings).get(RENDERER_SETTINGS_KEY)
                        if renderer_settings is not None:
                            new_settings = ONFViewItemsPortletNewsTightRendererSettings()
                            new_settings.list_reference = renderer_settings.list_reference
                            new_settings.link_label = renderer_settings.link_label
                            new_settings.__parent__ = settings
                            IAnnotations(settings)[RENDERER_SETTINGS_KEY] = new_settings
        # Update portlets context configuration
        for context in find_objects_providing(site, IPortalContext):
            portlets_configuration = IPortalPortletsConfiguration(context, None)
            if portlets_configuration is not None:
                for portlet in portlets_configuration.values():
                    if portlet.portlet_name == VIEW_PORTLET_NAME:
                        if portlet.inherit_parent:
                            continue
                        settings = portlet.settings
                        if settings.renderer != UPDATED_RENDERER_NAME:
                            continue
                        print("Upgrading view items portlet settings in {}".format(context))
                        renderer_settings = IAnnotations(settings).get(RENDERER_SETTINGS_KEY)
                        if renderer_settings is not None:
                            new_settings = ONFViewItemsPortletNewsTightRendererSettings()
                            new_settings.list_reference = renderer_settings.list_reference
                            new_settings.link_label = renderer_settings.link_label
                            new_settings.__parent__ = settings
                            IAnnotations(settings)[RENDERER_SETTINGS_KEY] = new_settings
    finally:
        set_local_registry(registry)
