#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.shared.casestudy import IWfCaseStudy
from onf_website.shared.casestudy.interfaces import ICaseStudyManager
from onf_website.shared.service import IWfService
from onf_website.shared.service.interfaces import IServiceManager
from pyams_i18n.interfaces import II18n
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, query_utility, set_local_registry


def evolve(site):
    """Evolve 2: rename resource annotations"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        manager = query_utility(ICaseStudyManager)
        if manager is not None:
            for case in find_objects_providing(manager, IWfCaseStudy):
                if case.references:
                    print("Upgrading logos for case study « {} »".format(II18n(case).query_attribute('title')))
                    case.logos = case.references.copy()
                    case.references = []
        manager = query_utility(IServiceManager)
        if manager is not None:
            for service in find_objects_providing(manager, IWfService):
                if service.references:
                    print("Upgrading logos for service « {} »".format(II18n(service).query_attribute('title')))
                    service.logos = service.references.copy()
                    service.references = []
    finally:
        set_local_registry(registry)
