#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.annotation import IAnnotations

from pyams_content.shared.resource import IWfResource, RESOURCE_INFO_ANNOTATIONS_KEY
from pyams_content.shared.resource.interfaces import IResourceManager
from pyams_i18n.interfaces import II18n
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, query_utility, set_local_registry


OLD_RESOURCE_INFO_ANNOTATIONS_KEY = 'onf_website.resource'


def evolve(site):
    """Evolve 2: rename resource annotations"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        manager = query_utility(IResourceManager)
        if manager is not None:
            for resource in find_objects_providing(manager, IWfResource):
                annotations = IAnnotations(resource)
                if OLD_RESOURCE_INFO_ANNOTATIONS_KEY in annotations:
                    print("Upgrading annotations for resource « {} »".format(II18n(resource).query_attribute('title')))
                    if RESOURCE_INFO_ANNOTATIONS_KEY in annotations:
                        del annotations[RESOURCE_INFO_ANNOTATIONS_KEY]
                    annotations[RESOURCE_INFO_ANNOTATIONS_KEY] = annotations[OLD_RESOURCE_INFO_ANNOTATIONS_KEY]
                    del annotations[OLD_RESOURCE_INFO_ANNOTATIONS_KEY]
    finally:
        set_local_registry(registry)
