#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.shared.common.portlet.specificities import SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME
from pyams_i18n.interfaces import II18n
from pyams_portal.interfaces import IPortalContext, IPortalPortletsConfiguration, IPortalTemplateContainer
from pyams_utils.container import find_objects_providing
from pyams_utils.registry import get_local_registry, query_utility, set_local_registry


OLD_SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME = 'onf_website.portlet.shared.specificities'


def evolve(site):
    """Evolve 1: rename annotations"""
    registry = get_local_registry()
    try:
        set_local_registry(site.getSiteManager())
        # Update templates configuration
        templates = query_utility(IPortalTemplateContainer)
        if templates is not None:
            for template in templates.values():
                for portlet in IPortalPortletsConfiguration(template).values():
                    if portlet.portlet_name == OLD_SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME:
                        print("Upgrading specificities portlet in {}".format(template.name))
                        portlet.portlet_name = SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME
        # Update portlets context configuration
        for context in find_objects_providing(site, IPortalContext):
            portlets_configuration = IPortalPortletsConfiguration(context, None)
            if portlets_configuration is not None:
                for portlet in portlets_configuration.values():
                    if portlet.portlet_name == OLD_SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME:
                        print("Upgrading specificities portlet in {}".format(II18n(context).query_attribute('title')))
                        portlet.portlet_name = SHARED_CONTENT_SPECIFICITIES_PORTLET_NAME
    finally:
        set_local_registry(registry)
