# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.features.thesaurus import IThesaurusTermFilterInfo
from pyams_default_theme.viewlet.tag import TagsContentProvider
from pyams_skin.layer import IPyAMSUserLayer
from pyams_viewlet.viewlet import contentprovider_config


@contentprovider_config(name='pyams.tags',
                        layer=IPyAMSUserLayer, view=Interface)
class ONFTagsContentProvider(TagsContentProvider):
    """ONF tags content provider"""
    
    @property
    def tags(self):
        tags = self.tags_info.tags or ()
        for tag in sorted(tags, key=lambda x: (x.order or 999, x.alt or x.label)):
            filter_info = IThesaurusTermFilterInfo(tag, None)
            if (filter_info is None) or filter_info.display_in_tags_list:
                yield tag
