from zope.annotation.interfaces import IAttributeAnnotatable
from zope.interface import Interface
from zope.schema import Bool, Choice

from pyams_content.reference.pictograms.interfaces import PICTOGRAM_VOCABULARY

from pyams_content import _


class IThesaurusTermFilterInfo(Interface):
    """Interface for managing thesaurus term features."""

    display_in_tags_list = Bool(
        title=_("Display in tags list"),
        description=_("Whether the term should be displayed in the tag list"),
        required=True,
        default=True)

    display_in_facets_list = Bool(
        title=_("Display in facets list"),
        description=_("Whether the term should be displayed in the facets list"),
        required=True,
        default=True)

    associated_pictogram = Choice(
        title=_("Associated pictogram"),
        description=_("Pictogram associated for display in the facets list"),
        vocabulary=PICTOGRAM_VOCABULARY,
        required=False)
    
    def get_pictogram(self):
        """Get associated pictogram object"""


class IThesaurusTermFilterTarget(IAttributeAnnotatable):
    """Thesaurus term filter target marker interface"""
