#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from onf_website.features.tarteaucitron import ITarteAuCitronInfo
from onf_website.skin.public import tarteaucitron_css
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_skin.interfaces.viewlet import IJSExtensionsViewletManager
from pyams_template.template import template_config
from pyams_viewlet.viewlet import Viewlet, viewlet_config


@viewlet_config(name='tarteaucitron', layer=IONFBaseLayer,
                manager=IJSExtensionsViewletManager)
@template_config(template='templates/tarteaucitron.pt', layer=IONFBaseLayer)
class TarteAuCitronViewlet(Viewlet):
    """TarteAuCitron integration viewlet"""

    def __new__(cls, context, request, view, manager):
        info = ITarteAuCitronInfo(request.root)
        if not info.enabled:
            return None
        return Viewlet.__new__(cls)

    def update(self):
        super().update()
        tarteaucitron_css.need()

    @property
    def config(self):
        info = ITarteAuCitronInfo(self.request.root)
        return info.to_json(self.request)

    @property
    def services(self):
        info = ITarteAuCitronInfo(self.request.root)
        return info.services
