#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.container.constraints import contains
from zope.interface import Attribute

from onf_website.features.search.skin.interfaces import IMapSearchResultsPortletRendererSettings
from onf_website.features.search.skin.interfaces.filter import IFilter, IFilterContainer, IFilterContainerTarget, \
    ISearchResultsPortletAdvancedFiltersRendererSettings
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_sequence.schema import InternalReferenceField

from onf_website import _


NEARME_FILTER_CONTAINER_ANNOTATION_KEY = 'onf_website.search.filters.nearme'


class INearmeFilter(IFilter):
    """Near-me filter interface"""
    
    
class INearmeFilterContainer(IFilterContainer):
    """Near-me filter container interface"""

    contains(INearmeFilter)


class INearmeFilterContainerTarget(IFilterContainerTarget):
    """Near-me filter container target marker interface"""


class INearmeSearchResultsPortletRendererSettings(ISearchResultsPortletAdvancedFiltersRendererSettings):
    """Near-me advanced filters search results portlet renderer settings"""

    display_results_count = Attribute("Removed attribute (display_results_count)")
    allow_sorting = Attribute("Removed attribute (allow_sorting)")
    allow_pagination = Attribute("Removed attribute (allow_pagination")
    header_display_mode = Attribute("Removed attribute (header_display_mode)")
    start_length = Attribute("Removed attribute (start_length)")
    
    presentation_mode_reference = InternalReferenceField(
            title=_("Alternate presentation mode reference"),
            description=_("Reference to the section handling the alternate presentation mode"),
            required=False)
    
    description = I18nTextField(title=_("Search description"),
                                required=False)

    dropdown_menu_title = I18nTextLineField(
            title=_("Dropdown menu title"),
            description=_("Label positioned above the dropdown menu"),
            required=False)
    
    region_title = I18nTextLineField(
            title=_("Region title"),
            description=_("Title displayed for the selected region, e.g. Île-de-France"),
            required=False)
    
    filters = Attribute("Search filters")


class INearmeMapSearchResultsPortletRendererSettings(INearmeSearchResultsPortletRendererSettings,
        IMapSearchResultsPortletRendererSettings):
    """Near-me search results portlet map renderer with head filters settings """

    map_height = Attribute("Removed attribute (map_height)")
