#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.features.search.portlet.interfaces import INearmePortletSettings

from pyams_form.form import AJAXEditForm
from pyams_pagelet.interfaces import IPagelet
from pyams_pagelet.pagelet import pagelet_config
from pyams_portal.interfaces import IPortletPreviewer
from pyams_portal.portlet import PortletPreviewer
from pyams_portal.zmi.portlet import PortletSettingsEditor
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


@pagelet_config(name='properties.html', context=INearmePortletSettings, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
class NearmyPortletSettingsEditor(PortletSettingsEditor):
    """Nearmy portlet settings editor"""

    settings = INearmePortletSettings


@adapter_config(name='properties.json', context=(INearmePortletSettings, IPyAMSLayer), provides=IPagelet)
class NearmyPortletSettingsAJAXEditor(AJAXEditForm, NearmyPortletSettingsEditor):
    """Nearmy portlet settings editor, JSON renderer"""


@adapter_config(context=(Interface, IPyAMSLayer, Interface, INearmePortletSettings),
                provides=IPortletPreviewer)
@template_config(template='templates/pdcm-preview.pt', layer=IPyAMSLayer)
class NearmyPortletPreviewer(PortletPreviewer):
    """Nearmy portlet previewer"""
