#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from zope.interface import Interface, implementer
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.location.skin.map import BaseMapMarkersRendererMixin
from onf_website.features.search.portlet.interfaces import INearmePopupPortletRendererSettings, \
    INearmePortletRendererSettings, INearmePortletSettings
from onf_website.features.search.skin import AggregatedSearchResultsRenderer
from onf_website.features.search.skin.nearme import NearmeMapSearchResultsPortletRendererSettings
from pyams_default_theme import _
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_portal.portlet import PortletRenderer
from pyams_sequence.reference import get_reference_target
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config
from pyams_utils.factory import factory_config


@factory_config(provided=INearmePortletRendererSettings)
@implementer(INearmePortletRendererSettings)
class NearmePortletRendererSettings():
    """Nearme portlet renderer settings"""

    redirect_target = FieldProperty(INearmePortletRendererSettings['redirect_target'])
  
  
@factory_config(provided=INearmePopupPortletRendererSettings)
@implementer(INearmePopupPortletRendererSettings)
class NearmePopupPortletRendererSettings(NearmeMapSearchResultsPortletRendererSettings):
    """Nearme popup portlet renderer settings"""


class BaseNearmePortletRenderer(PortletRenderer):
    """Base nearme renderer"""


@adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, INearmePortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/nearme-default.pt', layer=IPyAMSLayer)
class NearmePortletDefaultRenderer(BaseNearmePortletRenderer):
    """Near-me portlet default renderer"""

    label = _("Full page render")
    weight = 1

    settings_interface = INearmePortletRendererSettings

    @property
    def redirect_target(self):
        return get_reference_target(self.renderer_settings.redirect_target, request=self.request)


@adapter_config(name='nearme-popup',
                context=(IPortalContext, IPyAMSLayer, Interface, INearmePortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/nearme-popup.pt', layer=IPyAMSLayer)
class NearmePopupPortletDefaultRenderer(BaseMapMarkersRendererMixin,
                                        AggregatedSearchResultsRenderer):
    """Near-me popup portlet renderer"""
    
    label = _("Popup render")
    weight = 2

    settings_interface = INearmePopupPortletRendererSettings
