#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.features.search.skin.interfaces.nearme import INearmeMapSearchResultsPortletRendererSettings
from pyams_content.features.search.portlet.interfaces import ISearchResultsPortletSettings
from zope.interface import  Interface

from pyams_sequence.schema import InternalReferenceField

from pyams_content import _




class INearmePortletSettings(ISearchResultsPortletSettings):
    """Interface for the 'ONF: Near Me' component"""


class INearmePortletRendererSettings(Interface):
    """Interface for configuring a popup that can switch between map view and list view"""

    redirect_target = InternalReferenceField(title=_("Redirection target"),
                                         description=_("Target site or folder for handling redirection"),
                                         required=False)

    
class INearmePopupPortletRendererSettings(INearmeMapSearchResultsPortletRendererSettings):
    """interface for X"""
