#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.features.search.portlet import SearchResultsPortletSettings
from zope.interface import implementer

from onf_website.features.search.portlet.interfaces import INearmePortletSettings
from pyams_portal.portlet import Portlet, portlet_config
from pyams_utils.factory import factory_config
from pyams_utils.interfaces import VIEW_PERMISSION
from pyams_content.features.search.portlet import SearchResultsPortletSettings

from pyams_content import _


NEARMY_PORTLET_NAME = 'pyams_content.portlet.nearmy'


@factory_config(provided=INearmePortletSettings)
@implementer(INearmePortletSettings)
class NearmyPortletSettings(SearchResultsPortletSettings):
    """Spacer portlet settings"""

@portlet_config(permission=VIEW_PERMISSION)
class NearmyPortet(Portlet):
    """Toolbox portlet"""

    name = NEARMY_PORTLET_NAME

    label = _("ONF: Near Me")

    toolbar_css_class = 'fa fa-fw fa-2x fa-print'

    settings_factory = INearmePortletSettings
