#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Interface
from zope.schema import Bool

from pyams_file.schema import ImageField
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_sequence.interfaces import IInternalReference
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from onf_website import _


class IONFNavigationPortletRendererSettings(Interface):
    """ONF navigation portlet renderer settings interface"""

    header = I18nTextField(title=_("Header"),
                           description=_("Menu header displayed by front-office template"),
                           required=False)


class IONFNavigationPortletRendererSettingsWithSubtitle(IONFNavigationPortletRendererSettings):

    subtitle = I18nTextLineField(title=_("Subtitle"),
                                 description=_("Menu subtitle displayed by front-office template"),
                                 required=False)


class IONFNavigationPortletRendererSettingsWithBackground(IONFNavigationPortletRendererSettings):
    """ONF navigation portlet with subtitle and background images"""

    top_image = ImageField(title=_("Top image"),
                           required=False)

    bottom_left_image = ImageField(title=_("Bottom left image"),
                                   required=False)

    bottom_right_image = ImageField(title=_("Bottom right image"),
                                    required=False)


class IONFExternalNavigationPortletRendererSettings(Interface):
    """ONF external navigation portlet renderer settings interface"""

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label of the navigation button displayed by "
                                                   "front-office template"),
                                     required=False)


class IONFCatalogNavigationPortletRendererSettings(IInternalReference):
    """ONF catalog navigation portlet renderer settings interface"""

    teaser = I18nTextField(title=_("Teaser"),
                           description=_("Short text displayed before catalog items"),
                           required=False)

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label of the navigation button displayed by "
                                                   "front-office template if the target is "
                                                   "published"),
                                     required=False)


class IONFCarouselNavigationPortletRendererSettings(Interface):
    """ONF carousel navigation portlet renderer settings interface"""

    teaser = I18nTextField(title=_("Teaser"),
                           description=_("Short text displayed above carousel"),
                           required=False)


class IONFDoubleNavigationWithBackgroundPortletRendererSettings(Interface):
    """ONF carousel navigation portlet renderer settings interface"""

    subtitle = I18nTextLineField(title=_("Subtitle"),
                                 description=_("Navigation subtitle displayed by front-office "
                                               "template"),
                                 required=False)

    background = ImageField(title=_('double-navigation-background',
                                    default="Background illustration"),
                            description=_("Image displayed in background"),
                            required=False)


class IONFTopicNavigationPortletRendererSettings(Interface):
    """ONF topic navigation portlet renderer settings interface"""

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label of the navigation button displayed by "
                                                   "front-office template"),
                                     required=False)


class IONFLeisuresNavigationPortletRendererSettings(IInternalReference):
    """ONF leisures navigation portlet renderer settings"""

    button_label = I18nTextLineField(title=_("Button label"),
                                     description=_("Label of the navigation button displayed by "
                                                   "front-office template"),
                                     required=False)


class IONFMobileApplicationsNavigationPortletRendererSettings(IONFNavigationPortletRendererSettings):
    """ONF mobile applications navigation portlet renderer settings interface"""

    background_image = ImageField(title=_('mobile-applications-background',
                                          default="Background illustration"),
                                  description=_("Image displayed in background"),
                                  required=False)

    illustration = ImageField(title=_("Main illustration"),
                              description=_("Image displayed as application icon"),
                              required=False)


class IONFFramedNavigationPortletRendererSettings(Interface):
    """ONF framed navigation portlet renderer settings"""

    list_reference = InternalReferenceField(title=_("'All news' reference"),
                                            description=_("Internal reference to site or folder "
                                                          "displaying full list of view's "
                                                          "contents"),
                                            required=False)

    def get_target(self):
        """Get internal reference target"""

    link_label = I18nTextLineField(title=_("Link label"),
                                   description=_("Label of link to full list page"),
                                   required=False)

    intro_text = I18nTextField(title=_("Introduction text"),
                               description=_("Introduction text displayed by front-office "
                                             "template"),
                               required=False)

    frame_title = I18nTextLineField(title=_("Frame title"),
                                    description=_("Frame title displayed by front-office "
                                                  "template"),
                                    required=False)

    frame_body = I18nTextField(title=_("Frame body"),
                               description=_("Frame body text displayed by front-office "
                                             "template"),
                               required=False)

    include_context_settings = Bool(title=_("Include context settings"),
                                    description=_("If 'yes', context settings based on location "
                                                  "will be added to target URL"),
                                    required=True,
                                    default=False)
