#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Attribute, Interface
from zope.schema import Bool

from onf_website.shared.expengine.interfaces import EXPENGINE_CONTENT_TYPE
from pyams_content.features.header.interfaces import IHeaderRendererSettings
from pyams_file.schema import ImageField, MediaField
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from onf_website import _


class IDefaultHeaderRendererSettings(IHeaderRendererSettings):
    """Default ONF header renderer settings"""

    can_use_context_illustration = Attribute("Can use context illustration as background?")

    use_context_illustration = Bool(title=_("Use context illustration"),
                                    required=False,
                                    default=True)

    no_use_context_illustration = Bool(title=_("Don't use context illustration?"),
                                       required=False,
                                       default=False)

    background = MediaField(title=_("Background illustration"),
                            description=_("Image or video displayed in header background"),
                            required=False)

    heading = I18nTextLineField(title=_('header-heading', default="Heading"),
                                description=_("Heading displayed on top above background "
                                              "illustration"),
                                required=False)

    marianne = ImageField(title=_("Logo Marianne"),
                          description=_("First logo displayed in header"),
                          required=False)

    logo = ImageField(title=_("Logo ONF"),
                      description=_("Second logo displayed in header"),
                      required=False)

    show_frontispiece = Bool(title=_("Show frontispiece?"),
                             description=_("Set to 'yes' to display a frontispiece above "
                                           "top banner"),
                             required=True,
                             default=False)

    show_frontispiece_on_childs = Bool(title=_("Show on child levels"),
                                       description=_("If set to 'yes', childs levels which "
                                                     "inherit page header from this level will "
                                                     "also display the frontispiece"),
                                       required=True,
                                       default=False)

    show_frontispiece_on_shared_contents = Bool(title=_("Show on shared contents"),
                                                description=_("If set to 'yes', the frontispiece "
                                                              "will be visible on shared contents"),
                                                required=True,
                                                default=False)

    frontispiece = Attribute("Frontispiece links")

    accessibility_menu = Bool(title=_("Accessibility menu?"),
                              description=_("Set to 'no' to hide accessibility menu..."),
                              required=False,
                              default=True)

    show_subscriber_menu = Bool(title=_("Subscriber menu?"),
                                description=_("Set to 'no' to hide subscriber menu..."),
                                required=False,
                                default=False)

    subscriber_menu_label = I18nTextLineField(title=_("Subscriber menu label"),
                                              description=_("Label used for the subscriber menu"),
                                              required=False)

    subscriber_menu_header = I18nTextField(title=_("Subscriber menu header"),
                                           description=_("Text used to describe subscriber menu"),
                                           required=False)

    subscribers = Attribute("Subscriber menu links")

    search_menu = Bool(title=_("Search menu?"),
                       description=_("Set to 'no' to hide search menu..."),
                       required=False,
                       default=True)

    search_target = InternalReferenceField(title=_("Search form target"),
                                           description=_("Site or folder handling site search"),
                                           required=False)

    experiential_engine = InternalReferenceField(title=_("Experiential engine"),
                                                 description=_("Internal reference to "
                                                               "experiential engine to include "
                                                               "into search form"),
                                                 content_type=EXPENGINE_CONTENT_TYPE,
                                                 required=False)

    contact_menu = Bool(title=_("Contact link?"),
                        description=_("Set to 'no' to hide contact button..."),
                        required=False,
                        default=False)

    contact_target = InternalReferenceField(title=_("Contact link target"),
                                            description=_("Internal content displaying contact "
                                                          "information"),
                                            required=False)

    top = Attribute("Top links list")

    menus = Attribute("Header menus")

    social_links_header = I18nTextLineField(title=_("Social networks header"),
                                            description=_("Social networks links header title"),
                                            required=False)

    social = Attribute("Social links")


class IDefaultHeaderMenu(Interface):
    """Default header menu marker interface"""


class IDefaultHeaderFrontispieceMenu(IDefaultHeaderMenu):
    """Default header frontispiece menu marker interface"""


class IDefaultHeaderMenusContainer(Interface):
    """Default header menus container interface"""
