#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.features.footer import IONFFooterV2MenusContainer, IONFFooterV2RendererSettings
# import standard library

# import interfaces
from onf_website.features.footer.interfaces import IDefaultFooterRendererSettings, \
    IDefaultFooterMenu, IONFFooterV2Menu
from pyams_form.interfaces.form import IInnerSubForm
from pyams_portal.interfaces import MANAGE_TEMPLATE_PERMISSION
from pyams_skin.layer import IPyAMSLayer

# import packages
from pyams_content.features.footer.zmi import FooterSettingsRendererSettingsEditForm
from pyams_content.features.menu.zmi import IMenusView, LinksTable, MenuLinksView, IMenuLinksView, \
    MenusTable, \
    MenusView
from pyams_utils.adapter import adapter_config
from pyams_zmi.form import InnerAdminEditForm
from z3c.form import field

from onf_website import _


#
# Common components
#

class SocialLinksAssociationsTable(LinksTable):
    """Default footer social links associations table"""

    associations_name = 'social'


class SitesLinksAssociationsTable(LinksTable):
    """Default footer sites links associations table"""

    associations_name = 'sites'


class SitesMenusAssociationsTable(MenusTable):
    """Sites menus associations table"""

    associations_name = 'sites'


class ResourcesLinksAssociationsTable(LinksTable):
    """Default footer resources links associations table"""

    associations_name = 'resources'


class ContactsLinksAssociationsTable(LinksTable):
    """Default footer contacts links associations table"""

    associations_name = 'contacts'


class AppsLinksAssociationsTable(LinksTable):
    """Default footer applications links associations table"""

    associations_name = 'apps'


class LegalLinksAssociationsTable(LinksTable):
    """Default footer legal links associations table"""

    associations_name = 'legal'


#
# Footer v1
#

@adapter_config(name='default-footer-properties',
                context=(IDefaultFooterRendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
class DefaultFooterPropertiesEditForm(InnerAdminEditForm):
    """Default footer properties edit form"""

    legend = None

    fields = field.Fields(IDefaultFooterRendererSettings)
    edit_permission = MANAGE_TEMPLATE_PERMISSION

    weight = 1


#
# Social links table view
#

@adapter_config(name='default-footer-social-links',
                context=(IDefaultFooterRendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++social',
                context=(IDefaultFooterMenu, IPyAMSLayer),
                provides=IMenuLinksView)
class DefaultFooterSocialLinksView(MenuLinksView):
    """Default footer social links view"""

    title = _("Social networks links")

    table_class = SocialLinksAssociationsTable
    weight = 11


#
# Sites links table view
#

@adapter_config(name='default-footer-sites-links',
                context=(IDefaultFooterRendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++sites',
                context=(IDefaultFooterMenu, IPyAMSLayer),
                provides=IMenuLinksView)
class DefaultFooterSitesLinksView(MenuLinksView):
    """Default footer sites links view"""

    title = _("Sites links")

    table_class = SitesLinksAssociationsTable
    weight = 12


#
# Resources links table view
#

@adapter_config(name='default-footer-resources-links',
                context=(IDefaultFooterRendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++resources',
                context=(IDefaultFooterMenu, IPyAMSLayer),
                provides=IMenuLinksView)
class DefaultFooterResourcesLinksView(MenuLinksView):
    """Default footer resources links view"""

    title = _("Resources links")

    table_class = ResourcesLinksAssociationsTable
    weight = 13


#
# Contacts links table view
#

@adapter_config(name='default-footer-contacts-links',
                context=(IDefaultFooterRendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++contacts',
                context=(IDefaultFooterMenu, IPyAMSLayer),
                provides=IMenuLinksView)
class DefaultFooterContactsLinksView(MenuLinksView):
    """Default footer contacts links view"""

    title = _("Contacts links")

    table_class = ContactsLinksAssociationsTable
    weight = 14


#
# Applications links table view
#

@adapter_config(name='default-footer-apps-links',
                context=(IDefaultFooterRendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++apps',
                context=(IDefaultFooterMenu, IPyAMSLayer),
                provides=IMenuLinksView)
class DefaultFooterAppsLinksView(MenuLinksView):
    """Default footer apps links view"""

    title = _("Applications links")

    table_class = AppsLinksAssociationsTable
    weight = 15


#
# Legal links table view
#

@adapter_config(name='default-footer-legal-links',
                context=(IDefaultFooterRendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++legal',
                context=(IDefaultFooterMenu, IPyAMSLayer),
                provides=IMenuLinksView)
class DefaultFooterLegalLinksView(MenuLinksView):
    """Default footer legal links view"""

    title = _("Legal mentions links")

    table_class = LegalLinksAssociationsTable
    weight = 16


#
# Footer v2
#

@adapter_config(name='footer-properties-v2',
                context=(IONFFooterV2RendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
class ONFFooterV2PropertiesEditForm(InnerAdminEditForm):
    """ONF footer v2 properties edit form"""

    legend = None

    fields = field.Fields(IONFFooterV2RendererSettings)
    edit_permission = MANAGE_TEMPLATE_PERMISSION

    weight = 2

    def get_ajax_output(self, changes):
        if changes:
            return {
                'status': 'reload'
            }
        return super().get_ajax_output(changes)


@adapter_config(name='default-footer-social-links',
                context=(IONFFooterV2RendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++social',
                context=(IONFFooterV2Menu, IPyAMSLayer),
                provides=IMenuLinksView)
class ONFFooterV2SocialLinksView(MenuLinksView):
    """ONF footer v2 social links view"""

    title = _("Social networks links")

    table_class = SocialLinksAssociationsTable
    weight = 11


@adapter_config(name='default-footer-contacts-links',
                context=(IONFFooterV2RendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++contacts',
                context=(IONFFooterV2Menu, IPyAMSLayer),
                provides=IMenuLinksView)
class ONFFooterV2ContactsLinksView(MenuLinksView):
    """ONF footer v2 contacts links view"""

    title = _("Contacts links")

    table_class = ContactsLinksAssociationsTable
    weight = 12


@adapter_config(name='default-footer-sites-menus',
                context=(IONFFooterV2RendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++sites',
                context=(IONFFooterV2MenusContainer, IPyAMSLayer),
                provides=IMenusView)
class ONFFooterV2SitesMenusView(MenusView):
    """ONF footer v2 sites menus view"""

    title = _("Sites menus")

    table_class = SitesMenusAssociationsTable

    weight = 13


@adapter_config(name='default-footer-apps-links',
                context=(IONFFooterV2RendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++apps',
                context=(IONFFooterV2Menu, IPyAMSLayer),
                provides=IMenuLinksView)
class ONFFooterV2AppsLinksView(MenuLinksView):
    """ONF footer v2 apps links view"""

    title = _("Applications links")

    table_class = AppsLinksAssociationsTable
    weight = 14


@adapter_config(name='default-footer-legal-links',
                context=(IONFFooterV2RendererSettings, IPyAMSLayer,
                         FooterSettingsRendererSettingsEditForm),
                provides=IInnerSubForm)
@adapter_config(name='++ass++legal',
                context=(IONFFooterV2Menu, IPyAMSLayer),
                provides=IMenuLinksView)
class ONFFooterV2LegalLinksView(MenuLinksView):
    """ONF footer v2 legal links view"""

    title = _("Legal mentions links")

    table_class = LegalLinksAssociationsTable
    weight = 15
