#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Attribute, Interface

from pyams_content.features.footer.interfaces import IFooterRendererSettings
from pyams_file.schema import ImageField
from pyams_i18n.schema import I18nTextField, I18nTextLineField
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from onf_website import _


class IDefaultFooterRendererSettings(IFooterRendererSettings):
    """Default ONF footer renderer settings"""

    social_links_header = I18nTextLineField(title=_("Social networks header"),
                                            description=_("Social networks links header title"),
                                            required=False)

    social_links = Attribute("Social networks links list")

    sites_links_header = I18nTextLineField(title=_("Sites links header"),
                                           description=_("Sites links header title"),
                                           required=False)

    sites_links = Attribute("ONF sites links list")

    resources_links_header = I18nTextLineField(title=_("Resources links header"),
                                               description=_("Resources links header title"),
                                               required=False)

    resources_links = Attribute("Resources links list")

    contacts_links_header = I18nTextLineField(title=_("Contacts links header"),
                                              description=_("Contacts links header title"),
                                              required=False)

    contacts_links = Attribute("Contacts links list")

    apps_links_header = I18nTextLineField(title=_("Applications links header"),
                                          description=_("Applications links header title"),
                                          required=False)

    apps_links = Attribute("Applications links list")

    legal_links_signature = I18nTextLineField(title=_("Legal links signature"),
                                              description=_("Legal links footer signature"),
                                              required=False)

    legal_links = Attribute("Legal mentions links list")


class IONFFooterV2RendererSettings(IFooterRendererSettings):
    """ONF v2 footer renderer settings interface"""

    logo = ImageField(title=_("Logo"),
                      description=_("Footer logo"),
                      required=False)

    social_links_title = I18nTextLineField(title=_("Social networks title"),
                                           description=_("Social networks links title"),
                                           required=False)

    social_links = Attribute("Social networks links list")

    newsletter_title = I18nTextLineField(title=_("Newsletter title"),
                                         description=_("This is the title of the newsletter "
                                                       "block"),
                                         required=False)

    newsletter_header = I18nTextLineField(title=_("Newsletter header"),
                                          description=_("This is the header of the newsletter "
                                                        "block"),
                                          required=False)

    newsletter_reference = InternalReferenceField(title=_("Newsletter link target"),
                                                  description=_("This is the content target of "
                                                                "the newsletter link"),
                                                  required=False)

    newsletter_target = Attribute("Newsletter link internal target")

    newsletter_link_title = I18nTextLineField(title=_("Newsletter link title"),
                                              description=_("Alternate title of the newsletter "
                                                            "link"),
                                              required=False)

    contacts_links_title = I18nTextLineField(title=_("Contacts links title"),
                                             description=_("This is the title of the contacts "
                                                           "links block"),
                                             required=False)

    contacts_links_header = I18nTextField(title=_("Contacts links header"),
                                          description=_("This is the header of the contacts "
                                                        "links block"),
                                          required=False)

    contacts_links = Attribute("Contacts links list")

    sites_menus_title = I18nTextLineField(title=_("Sites menus title"),
                                          required=False)

    sites = Attribute("Sites menus list")

    apps_links_title = I18nTextLineField(title=_("Applications links title"),
                                         description=_("Applications links title"),
                                         required=False)

    apps_links = Attribute("Applications links list")

    legal_links_signature = I18nTextLineField(title=_("Legal links signature"),
                                              description=_("Legal links footer signature"),
                                              required=False)

    legal_links = Attribute("Legal mentions links list")


class IDefaultFooterMenu(Interface):
    """Default footer menu marker interface"""


class IONFFooterV2MenusContainer(Interface):
    """Footer v2 menus container marker interface"""


class IONFFooterV2Menu(Interface):
    """Footer v2 menu marker interface"""
