# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from pprint import pformat

from zope.interface import implementer
from zope.schema.fieldproperty import FieldProperty

from onf_website.features.firebase import IFirebaseSubscriptions
from onf_website.features.firebase.interfaces import IFirebaseSubscriptionsCheckerTask
from pyams_content.root import ISiteRoot
from pyams_scheduler.task import Task
from pyams_utils.traversing import get_parent

__docformat__ = 'restructuredtext'


@implementer(IFirebaseSubscriptionsCheckerTask)
class FirebaseSubscriptionsCheckerTask(Task):
    """Firebase subscriptions checker task"""
    
    dry_mode = FieldProperty(IFirebaseSubscriptionsCheckerTask['dry_mode'])
    
    def run(self, report):
        root = get_parent(self, ISiteRoot)
        subscriptions = IFirebaseSubscriptions(root)
        output = subscriptions.check_subscriptions(drop_invalid=not self.dry_mode)
        if output:
            report.write('\nDeleted invalid Firebase subscriptions tokens:\n')
            report.write(pformat(output))
