#
# Copyright (c) 2015-2023 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from colander import MappingSchema, SchemaNode, SequenceSchema, String, drop

from pyams_utils.rest import BaseResponseSchema, StringListSchema


class Subscription(MappingSchema):
    """Subscription schema"""
    firebase_id = SchemaNode(String(),
                             description="Firebase token ID")
    content_type = SchemaNode(String(),
                              description="Subscription content_type")
    forest_ids = StringListSchema(description="List of forest IDs for which subscription is active")


class SubscriptionsGetterQuery(MappingSchema):
    """Subscriptions getter """
    firebase_id = SchemaNode(String(),
                             description="Firebase token ID")
    content_type = SchemaNode(String(),
                              description="Content type",
                              missing=drop)


class SubscriptionsGetterRequest(MappingSchema):
    """Subscriptions getter request"""
    querystring = SubscriptionsGetterQuery()


class SubscriptionsGetterResults(SequenceSchema):
    """Subscriptions getter results"""
    subscription = Subscription()


class SubscriptionsGetterBody(BaseResponseSchema):
    """Subscriptions getter response"""
    subscriptions = SubscriptionsGetterResults(description="Subscriptions getter results",
                                               missing=drop)


class SubscriptionsGetterResponse(MappingSchema):
    """Subscriptions getter response"""
    body = SubscriptionsGetterBody()


class SubscriptionsSetterQuery(MappingSchema):
    """Subscriptions setter query"""
    body = Subscription()


class SubscriptionsSetterBody(BaseResponseSchema):
    """Subscriptions setter body"""
    subscriptions = SubscriptionsGetterResults(description="Subscriptions setter results",
                                               missing=drop)


class SubscriptionsSetterResponse(MappingSchema):
    """Subscriptions setter response"""
    body = SubscriptionsSetterBody()


class SubscriptionsPatchQuery(MappingSchema):
    """Subscriptions patch query"""
    old_firebase_id = SchemaNode(String(),
                                 description="Old Firebase token ID")
    new_firebase_id = SchemaNode(String(),
                                 description="New Firebase token ID")


class SubscriptionsPatchQueryBody(MappingSchema):
    """Subscriptions patch query body"""
    body = SubscriptionsPatchQuery()


class SubscriptionsPatchBody(BaseResponseSchema):
    """Subscriptions patch body"""
    subscriptions = SubscriptionsGetterResults(description="Subscriptions patch results",
                                               missing=drop)


class SubscriptionsPatchResponse(MappingSchema):
    """Subscriptions patch response"""
    body = SubscriptionsPatchBody()


class SubscriptionsDeleteQuery(MappingSchema):
    """Subscriptions delete query"""
    firebase_id = SchemaNode(String(),
                             description="Firebase token ID")
    content_type = SchemaNode(String(),
                              description="Subscription content type; if argument is not provided, all "
                                          "subscriptions will be removed",
                              missing=drop)
    forest_ids = StringListSchema(description="List of forest IDs for which subscription is active "
                                              "must be removed; if argument is not provided, all "
                                              "content type subscriptions will be removed",
                                  missing=drop)


class SubscriptionsDeleteQueryBody(MappingSchema):
    """Subscriptions delete query"""
    body = SubscriptionsDeleteQuery()


class SubscriptionsDeleteBody(BaseResponseSchema):
    """Subscriptions delete body"""
    subscriptions = SubscriptionsGetterResults(description="Subscriptions delete results",
                                               missing=drop)


class SubscriptionsDeleteResponse(MappingSchema):
    """Subscriptions delete response"""
    body = SubscriptionsDeleteBody()
