#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from persistent.cPersistence import Persistent
from zope.location import Location
from zope.schema.fieldproperty import FieldProperty

from onf_website import _
from onf_website.component.paragraph.skin.interfaces.video import \
    CIRCULAR_VIDEO_RENDERER_SETTINGS_KEY
from onf_website.component.video.skin.interfaces import ICircularExternalVideoParagraphSettings
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.video.interfaces import IExternalVideoParagraph
from pyams_content.features.renderer import IContentRenderer
from pyams_default_theme.component.video import ExternalVideoParagraphDefaultRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import override_template, template_config
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config


override_template(context=ExternalVideoParagraphDefaultRenderer, layer=IONFBaseLayer,
                  template='templates/external-video-default.pt')
override_template(name='PARA:title-left',
                  context=ExternalVideoParagraphDefaultRenderer, layer=IONFBaseLayer,
                  template='templates/external-video-title-left.pt')


#
# Custom external videos paragraphs renderers
#

@factory_config(provided=ICircularExternalVideoParagraphSettings)
class CircularExternalVideoParagraphSettings(Persistent, Location):
    """Circular external video renderer settings factory"""

    title = FieldProperty(ICircularExternalVideoParagraphSettings['title'])
    body = FieldProperty(ICircularExternalVideoParagraphSettings['body'])


@adapter_config(context=IExternalVideoParagraph,
                provides=ICircularExternalVideoParagraphSettings)
def circular_external_video_paragraph_renderer_settings_factory(context):
    """Circular external video renderer settings factory"""
    return get_annotation_adapter(context, CIRCULAR_VIDEO_RENDERER_SETTINGS_KEY,
                                  ICircularExternalVideoParagraphSettings)


@adapter_config(name='circle+left',
                context=(IExternalVideoParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/external-video-left-circle.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/external-video-title-left.pt', layer=IPyAMSLayer)
class LeftCircleExternalVideoParagraphRenderer(ExternalVideoParagraphDefaultRenderer):
    """Left circle external video paragraph renderer"""

    label = _("ONF: Circular illustration on the left")
    weight = 10

    settings_interface = ICircularExternalVideoParagraphSettings


@adapter_config(name='circle+right',
                context=(IExternalVideoParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/external-video-right-circle.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/external-video-title-left.pt', layer=IPyAMSLayer)
class RightCircleExternalVideoParagraphRenderer(ExternalVideoParagraphDefaultRenderer):
    """Right circle external video paragraph renderer"""

    label = _("ONF: Circular illustration on the right")
    weight = 20

    settings_interface = ICircularExternalVideoParagraphSettings
