#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface
from zope.schema import Choice


__docformat__ = 'restructuredtext'

from onf_website import _


ONF_VERBATIM_PARAGRAPH_RENDERER_SETTINGS_KEY = 'onf_website.verbatim.renderer:default'


class IONFVerbatimParagraphRendererSettings(Interface):
    """Default verbatim paragraph renderer settings interface"""

    xs_horizontal_padding = Choice(title=_("XS horizontal padding"),
                                   description=_("Define horizontal padding for smartphones"),
                                   required=False,
                                   values=list(range(5)))

    sm_horizontal_padding = Choice(title=_("SM horizontal padding"),
                                   description=_("Define hoirzontal padding for tablets"),
                                   required=False,
                                   values=list(range(5)))

    md_horizontal_padding = Choice(title=_("MD horizontal padding"),
                                   description=_("Define horizontal padding for medium screens"),
                                   required=False,
                                   values=list(range(5)))

    lg_horizontal_padding = Choice(title=_("LG horizontal padding"),
                                   description=_("Define horizontal padding for large screens"),
                                   required=False,
                                   values=list(range(5)))

    def has_padding(self):
        """Check if any padding is defined"""
