#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from zope.interface import Interface

from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.verbatim.portlet import IVerbatimPortletSettings
from pyams_default_theme.component.verbatim.portlet import VerbatimPortletDefaultRenderer
from pyams_portal.interfaces import IPortalContext, IPortletRenderer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config


@adapter_config(context=(IPortalContext, IONFBaseLayer, Interface, IVerbatimPortletSettings),
                provides=IPortletRenderer)
@template_config(template='templates/verbatim-portlet.pt', layer=IONFBaseLayer)
class ONFVerbatimPortletDefaultRenderer(VerbatimPortletDefaultRenderer):
    """Verbatims portlet default renderer"""
