#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from persistent.cPersistence import Persistent
from zope.location import Location
from zope.schema.fieldproperty import FieldProperty

from onf_website.component.paragraph.skin.interfaces.video import \
    CIRCULAR_VIDEO_RENDERER_SETTINGS_KEY, ICircularVideoParagraphSettings
from onf_website.skin.public.layer import IONFBaseLayer
from pyams_content.component.paragraph.interfaces.video import IVideoParagraph
from pyams_content.features.renderer import IContentRenderer
from pyams_default_theme.component.paragraph.video import VideoParagraphDefaultRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import override_template, template_config
from pyams_utils.adapter import adapter_config, get_annotation_adapter
from pyams_utils.factory import factory_config

from onf_website import _


override_template(context=VideoParagraphDefaultRenderer, layer=IONFBaseLayer,
                  template='templates/video-default.pt')
override_template(name='PARA:title-left',
                  context=VideoParagraphDefaultRenderer, layer=IONFBaseLayer,
                  template='templates/video-title-left.pt')


#
# Custom videos paragraph renderers
#

@factory_config(provided=ICircularVideoParagraphSettings)
class CircularVideoParagraphSettings(Persistent, Location):
    """Circular video paragraph settings"""

    title = FieldProperty(ICircularVideoParagraphSettings['title'])
    body = FieldProperty(ICircularVideoParagraphSettings['body'])


@adapter_config(context=IVideoParagraph,
                provides=ICircularVideoParagraphSettings)
def circular_video_paragraph_renderer_settings_factory(context):
    """Circular video renderer settings factory"""
    return get_annotation_adapter(context, CIRCULAR_VIDEO_RENDERER_SETTINGS_KEY,
                                  ICircularVideoParagraphSettings)


@adapter_config(name='circle+left',
                context=(IVideoParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/video-left-circle.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/video-title-left.pt', layer=IPyAMSLayer)
class LeftCircleVideoParagraphRenderer(VideoParagraphDefaultRenderer):
    """Left circle video paragraph renderer"""

    label = _("ONF: Circular illustration on the left")
    weight = 10

    settings_interface = ICircularVideoParagraphSettings


@adapter_config(name='circle+right',
                context=(IVideoParagraph, IPyAMSLayer),
                provides=IContentRenderer)
@template_config(template='templates/video-right-circle.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/video-title-left.pt', layer=IPyAMSLayer)
class RightCircleVideoParagraphRenderer(VideoParagraphDefaultRenderer):
    """Right circle video paragraph renderer"""

    label = _("ONF: Circular illustration on the right")
    weight = 20

    settings_interface = ICircularVideoParagraphSettings
