#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.paragraph.interfaces.pictogram import IPictogramParagraph
from pyams_content.features.renderer import IContentRenderer
from pyams_default_theme.component.paragraph.pictogram import \
    DefaultPictogramParagraphRenderer as BasePictogramParagraphRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config

from pyams_template.template import override_template
from pyams_template.template import template_config


from onf_website import _


#
#  Pictogram paragraph renderer
#


override_template(name='PARA:title-left',
                  context=BasePictogramParagraphRenderer,
                  template='templates/pictogram-title-left.pt',
                  layer=IPyAMSLayer)


@adapter_config(name='default', context=(IPictogramParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/pictogram-default.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/pictogram-title-left.pt', layer=IPyAMSLayer)
class ONFGridPictogramParagraphRenderer(BasePictogramParagraphRenderer):
    """ONF Grid Pictogram renderer"""

    label = _("ONF: Default grid of pictograms renderer")
    weight = 1


@adapter_config(name='ONF:;pictobubble', context=(IPictogramParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/pictogram-bubble.pt', layer=IPyAMSLayer)
@template_config(name='PARA:title-left',
                 template='templates/pictogram-bubble-title-left.pt', layer=IPyAMSLayer)
class ONFBubblePictogramParagraphRenderer(BasePictogramParagraphRenderer):
    """ONF Surrounded Pictogram renderer"""

    label = _("ONF: Surrounded pictograms renderer")
    weight = 2
