#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.paragraph.interfaces.milestone import IMilestoneContainer, IMilestoneParagraph
from pyams_content.features.renderer import IContentRenderer
from pyams_default_theme.component.paragraph.milestone import DefaultMilestoneParagraphRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

from onf_website import _


#
# Milestone paragraph default renderer
#

@adapter_config(name='default', context=(IMilestoneParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/milestone-default.pt', layer=IPyAMSLayer)
class ONFDefaultMilestoneRenderer(DefaultMilestoneParagraphRenderer):
    """Default milestones renderer"""

    label = _("ONF: Default milestone renderer")
    weight = 1


#
# Milestone paragraph date-to-date renderer
#

@adapter_config(name='period', context=(IMilestoneParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/milestone-period.pt', layer=IPyAMSLayer)
class ONFPeriodMilestoneRenderer(DefaultMilestoneParagraphRenderer):
    """Period milestones renderer"""

    label = _("ONF: Date-to-date milestone renderer")
    weight = 2

    @property
    def milestones(self):
        return IMilestoneContainer(self.context)
