#
# Copyright (c) 2015-2021 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

from zope.interface import Interface

from pyams_i18n.schema import I18nTextField, I18nTextLineField


__docformat__ = 'restructuredtext'

from onf_website import _


CIRCULAR_VIDEO_RENDERER_SETTINGS_KEY = 'onf_website.video.renderer:circle'


class ICircularVideoParagraphSettings(Interface):
    """Circular video paragraph settings interface"""

    title = I18nTextLineField(title=_("Title"),
                              description=_("This title will be displayed in text area "
                                            "in front of the video illustration"),
                              required=False)

    body = I18nTextField(title=_("Associated text"),
                         description=_("This text will be displayed in text area "
                                       "in front of the video illustration"),
                         required=False)
