#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from zope.interface import Attribute
from zope.schema import URI

from pyams_default_theme.component.paragraph.interfaces.frame import IDefaultFrameParagraphRendererSettings, \
    ILateralFrameParagraphRendererSettings
from pyams_i18n.schema import I18nTextLineField
from pyams_sequence.schema import InternalReferenceField


__docformat__ = 'restructuredtext'

from onf_website import _


class IUnborderedFrameParagraphRendererSettings(IDefaultFrameParagraphRendererSettings):
    """Un-bordered framed paragraph default renderer settings interface"""


class IUnborderedLeftFrameParagraphRendererSettings(ILateralFrameParagraphRendererSettings):
    """Left un-bordered framed paragraph lateral renderer settings interface"""


class IUnborderedRightFrameParagraphRendererSettings(ILateralFrameParagraphRendererSettings):
    """Right un-bordered framed paragraph lateral renderer settings interface"""


ACTION_FRAME_PARAGRAPH_RENDERER_SETTINGS_KEY = 'pyams_content.frame.renderer:action'


class IActionFrameParagraphRendererSettings(IDefaultFrameParagraphRendererSettings):
    """Call-to-action framed paragraph renderer settings interface"""

    button_label = I18nTextLineField(title=_("Button label"),
                                     required=False)

    button_target_reference = InternalReferenceField(title=_("Button target reference"),
                                                     description=_("Reference to button internal target"),
                                                     required=False)

    button_target_url = URI(title=_("Button target URL"),
                            description=_("URL of external button target"),
                            required=False)

    button_target = Attribute("Button target")
