#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from onf_website.component.paragraph.interfaces.client import IClientParagraph

from pyams_content.features.renderer import IContentRenderer
from pyams_default_theme.features.renderer import BaseContentRenderer
from pyams_sequence.reference import get_reference_target
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

from onf_website import _


@adapter_config(name='default', context=(IClientParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/client-default.pt', layer=IPyAMSLayer)
class ClientParagraphDefaultRenderer(BaseContentRenderer):
    """Client paragraph default renderer"""

    label = _("Default client renderer")
    context_attrs = ('logo', 'name', 'photo', 'gps_location')
    i18n_context_attrs = ('title', 'text_1', 'title_2', 'text_2',
                          'quote', 'charge', 'project_start', 'project_end')

    def get_logo(self):
        if self.logo is not None:
            return get_reference_target(self.logo)
