#
# Copyright (c) 2008-2015 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'

from pyams_content.component.paragraph.interfaces.audio import IAudioParagraph
from pyams_content.features.renderer import IContentRenderer
from pyams_default_theme.component.paragraph.audio import DefaultAudioParagraphRenderer as BaseAudioParagraphRenderer
from pyams_skin.layer import IPyAMSLayer
from pyams_template.template import template_config
from pyams_utils.adapter import adapter_config

from onf_website import _


#
#  Audio paragraph default renderer
#

@adapter_config(name='default', context=(IAudioParagraph, IPyAMSLayer), provides=IContentRenderer)
@template_config(template='templates/audio-default.pt', layer=IPyAMSLayer)
class DefaultAudioParagraphRenderer(BaseAudioParagraphRenderer):
    """Default key numbers renderer"""

    label = _("Default audio renderer")
