#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from zope.schema import Bool

    from pyams_default_theme.component.map.interfaces import \
        IMapParagraphDefaultRendererSettings as IMapParagraphDefaultRendererSettingsBase

    from onf_website import _


    class IMapParagraphDefaultRendererSettings(IMapParagraphDefaultRendererSettingsBase):
        """Map paragraph default renderer settings interface"""

        display_context_forests = Bool(title=_("Display location forests?"),
                                       description=_("If 'yes', and if forests have been "
                                                     "selected into context location, these "
                                                     "forests will be displayed into location "
                                                     "map"),
                                       required=True,
                                       default=True)

        set_bounds_to_forests = Bool(title=_("Set bounds to forests?"),
                                     description=_("If 'yes', map will be centered on selected "
                                                   "forests bounds instead of given GPS "
                                                   "position"),
                                     required=True,
                                     default=True)
