#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'

from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from pyramid.decorator import reify
    from zope.interface import Interface
    from zope.schema.fieldproperty import FieldProperty

    from onf_website.component.map.portlet.skin.interfaces import \
        IMapPortletDefaultRendererSettings, IONFMapPortletHalfWidthRendererSettings
    from onf_website.component.map.skin import BaseMapRendererMixin
    from onf_website.shared.forest.interfaces import IWfForest
    from pyams_content.component.map.portlet import IMapPortletSettings
    from pyams_default_theme.component.map.portlet import \
        MapPortletDefaultRenderer as BaseMapPortletDefaultRenderer, \
        MapPortletDefaultRendererSettings as BaseMapPortletDefaultRendererSettings
    from pyams_portal.interfaces import IPortalContext, IPortletRenderer
    from pyams_skin.layer import IPyAMSLayer
    from pyams_template.template import template_config
    from pyams_utils.adapter import adapter_config
    from pyams_utils.factory import factory_config

    from onf_website import _


    @factory_config(IMapPortletDefaultRendererSettings)
    class MapPortletDefaultRendererSettings(BaseMapPortletDefaultRendererSettings):
        """Map portlet default renderer settings"""

        display_context_forests = FieldProperty(
            IMapPortletDefaultRendererSettings['display_context_forests'])
        set_bounds_to_forests = FieldProperty(
            IMapPortletDefaultRendererSettings['set_bounds_to_forests'])


    @adapter_config(context=(IPortalContext, IPyAMSLayer, Interface, IMapPortletSettings),
                    provides=IPortletRenderer)
    @template_config(template='templates/map-default.pt', layer=IPyAMSLayer)
    class MapPortletDefaultRenderer(BaseMapRendererMixin,
                                    BaseMapPortletDefaultRenderer):
        """Map portlet default renderer"""

        settings_interface = IMapPortletDefaultRendererSettings

        @reify
        def gps_locations(self):
            return self.get_gps_locations(self.context, self.settings, self.renderer_settings)

        def get_map_configuration(self):
            return super().get_map_configuration(self.context, self.settings,
                                                 self.renderer_settings)

        def get_markers(self):
            return super().get_markers(self.context, self.settings, self.renderer_settings)

        def get_gps_position(self):
            return super().get_gps_position(self.context, self.settings, self.renderer_settings)


    @factory_config(IONFMapPortletHalfWidthRendererSettings)
    class ONFMapPortletHalfWidthRendererSettings(MapPortletDefaultRendererSettings):
        """ONF map portlet half width renderer settings"""

        display_department = FieldProperty(
            IONFMapPortletHalfWidthRendererSettings['display_department'])
        display_communes = FieldProperty(
            IONFMapPortletHalfWidthRendererSettings['display_communes'])


    @adapter_config(name='ONF::map.half-width',
                    context=(IPortalContext, IPyAMSLayer, Interface, IMapPortletSettings),
                    provides=IPortletRenderer)
    @template_config(template='templates/map-halfwidth.pt', layer=IPyAMSLayer)
    class ONFMapPortletHalfWidthRenderer(MapPortletDefaultRenderer):
        """ONF map portlet half-width renderer"""

        label = _("ONF: Forest location map")
        weight = 2

        settings_interface = IONFMapPortletHalfWidthRendererSettings

        def render(self, template_name=''):
            forest = IWfForest(self.context, None)
            if forest is None:
                return ''
            return super().render(template_name)
