#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from zope.schema import Bool

    from pyams_content.component.map.portlet import \
        IMapPortletSettings as IMapPortletSettingsBase

    from onf_website import _


    class IMapPortletSettings(IMapPortletSettingsBase):
        """Map portlet settings base"""

        use_context_location = Bool(title=_("Use context location?"),
                                    description=_("If 'yes', map will use context location"),
                                    required=True,
                                    default=True)

        no_use_context_location = Bool(title=_("Don't use context location?"),
                                       description=_("If 'yes', map will not use context "
                                                     "location"),
                                       required=False,
                                       default=False)
