#
# Copyright (c) 2015-2022 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

"""PyAMS_*** module

"""

__docformat__ = 'restructuredtext'


from pyams_content.component.map.interfaces import have_gis
if have_gis:

    from zope.schema.fieldproperty import FieldProperty

    from onf_website.component.map.portlet.interfaces import IMapPortletSettings
    from pyams_content.component.map.portlet import \
        MapPortlet as BaseMapPortlet, \
        MapPortletSettings as BaseMapPortletSettings
    from pyams_portal.portlet import portlet_config
    from pyams_utils.factory import factory_config
    from pyams_utils.interfaces import VIEW_PERMISSION


    @factory_config(IMapPortletSettings)
    class MapPortletSettings(BaseMapPortletSettings):
        """Map portlet settings"""

        _use_context_location = FieldProperty(IMapPortletSettings['use_context_location'])

        @property
        def use_context_location(self):
            return self._use_context_location

        @use_context_location.setter
        def use_context_location(self, value):
            self._use_context_location = value

        @property
        def no_use_context_location(self):
            return not bool(self.use_context_location)

        @no_use_context_location.setter
        def no_use_context_location(self, value):
            self.use_context_location = not bool(value)


    @portlet_config(permission=VIEW_PERMISSION)
    class MapPortlet(BaseMapPortlet):
        """Map portlet class"""

        settings_factory = IMapPortletSettings
