#
# Copyright (c) 2008-2017 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import button, field
from z3c.form.interfaces import INPUT_MODE
from zope.interface import Interface, implementer

from onf_website.component.location.interfaces import IViewLocationSettings, LOCATION_SETTINGS
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_content.shared.common.zmi import WfSharedContentHeaderAdapter
from pyams_content.shared.view.interfaces import IWfView
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerSubForm, IUncheckedEditFormButtons, IWidgetForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.interfaces import IInnerPage, IPageHeader
from pyams_skin.layer import IPyAMSLayer
from pyams_skin.viewlet.menu import MenuItem
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION
from pyams_viewlet.viewlet import viewlet_config
from pyams_zmi.form import AdminEditForm, InnerAdminEditForm
from pyams_zmi.interfaces.menu import IPropertiesMenu
from pyams_zmi.layer import IAdminLayer


__docformat__ = 'restructuredtext'


from onf_website import _


@viewlet_config(name='location.menu',
                context=IWfView, layer=IAdminLayer,
                manager=IPropertiesMenu, weight=310,
                permission=VIEW_SYSTEM_PERMISSION)
class LocationMenu(MenuItem):
    """Location menu"""

    label = _("Location...")
    icon_class = 'fa-map-marker'
    url = '#location.html'


@pagelet_config(name='location.html',
                context=IWfView, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='location.json',
             context=IWfView, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
@implementer(IWidgetForm, IInnerPage)
class LocationEditForm(AdminEditForm):
    """Location settings edit form"""

    prefix = 'view_location_form.'

    legend = _("View location settings")

    fields = field.Fields(Interface)

    @property
    def buttons(self):
        if self.mode == INPUT_MODE:
            return button.Buttons(IUncheckedEditFormButtons)
        return button.Buttons(Interface)


@adapter_config(name='gps',
                context=(IWfView, IPyAMSLayer, LocationEditForm),
                provides=IInnerSubForm)
class LocationCoordinatesEditSubform(InnerAdminEditForm):
    """Location coordinates edit form"""

    prefix = 'location_gps.'

    legend = None
    main_group_legend = LOCATION_SETTINGS['gps']

    fields = field.Fields(IViewLocationSettings).select('select_context_gps_location',
                                                        'gps_location', 'gps_distance',
                                                        'gps_area')
    weight = 1


@adapter_config(name='location',
                context=(IWfView, IPyAMSLayer, LocationEditForm),
                provides=IInnerSubForm)
class LocationMainEditSubform(InnerAdminEditForm):
    """Location main edit form"""

    prefix = 'location_location.'

    legend = None
    main_group_legend = LOCATION_SETTINGS['location']

    fields = field.Fields(IViewLocationSettings).select('select_context_forests', 'forests',
                                                        'select_context_cities', 'cities')
    weight = 2


@adapter_config(name='insee',
                context=(IWfView, IPyAMSLayer, LocationEditForm),
                provides=IInnerSubForm)
class LocationAddressEditSubform(InnerAdminEditForm):
    """Location address edit form"""

    prefix = 'location_insee.'

    legend = None
    main_group_legend = LOCATION_SETTINGS['insee']

    fields = field.Fields(IViewLocationSettings).select('select_context_departments', 'departments',
                                                        'select_context_countries', 'countries')
    weight = 3


@adapter_config(name='structure',
                context=(IWfView, IPyAMSLayer, LocationEditForm),
                provides=IInnerSubForm)
class LocationStructuresEditSubform(InnerAdminEditForm):
    """Location structures edit form"""

    prefix = 'location_structure.'

    legend = None
    main_group_legend = LOCATION_SETTINGS['structure']

    fields = field.Fields(IViewLocationSettings).select('select_context_structures', 'structures')
    weight = 4


@adapter_config(context=(IWfView, IAdminLayer, LocationEditForm),
                provides=IPageHeader)
class LocationHeaderAdapter(WfSharedContentHeaderAdapter):
    """Shared content location header adapter"""

    icon_class = 'fa fa-fw fa-map-marker'
