#
# Copyright (c) 2008-2018 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#

from z3c.form import field

from onf_website.component.location.interfaces import IViewLocationSettings
from onf_website.component.location.zmi.view import LocationAddressEditSubform, \
    LocationCoordinatesEditSubform, LocationEditForm, LocationMainEditSubform, \
    LocationStructuresEditSubform
from pyams_content.features.search import ISearchFolder
from pyams_content.interfaces import MANAGE_CONTENT_PERMISSION
from pyams_form.form import ajax_config
from pyams_form.interfaces.form import IInnerSubForm
from pyams_pagelet.pagelet import pagelet_config
from pyams_skin.layer import IPyAMSLayer
from pyams_utils.adapter import adapter_config
from pyams_utils.interfaces import VIEW_SYSTEM_PERMISSION


__docformat__ = 'restructuredtext'

from onf_website import _


@pagelet_config(name='location.html',
                context=ISearchFolder, layer=IPyAMSLayer,
                permission=VIEW_SYSTEM_PERMISSION)
@ajax_config(name='location.json',
             context=ISearchFolder, layer=IPyAMSLayer,
             permission=MANAGE_CONTENT_PERMISSION)
class SearchFolderLocationEditForm(LocationEditForm):
    """Location settings edit form"""

    legend = _("Search folder location settings")


@adapter_config(name='gps',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderLocationEditForm),
                provides=IInnerSubForm)
class SearchFolderLocationCoordinatesEditSubform(LocationCoordinatesEditSubform):
    """Search folder location coordinates edit form"""

    fields = field.Fields(IViewLocationSettings).select('gps_location', 'gps_distance', 'gps_area')

    def updateWidgets(self, prefix=None):
        super().updateWidgets(prefix)
        if 'gps_location' in self.widgets:
            self.widgets['gps_location'].label = _("GPS location")


@adapter_config(name='location',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderLocationEditForm),
                provides=IInnerSubForm)
class SearchFolderLocationMainEditSubform(LocationMainEditSubform):
    """Search folder location main edit form"""

    fields = field.Fields(IViewLocationSettings).select('forests', 'cities')

    def updateWidgets(self, prefix=None):
        super().updateWidgets(prefix)
        if 'forests' in self.widgets:
            self.widgets['forests'].label = _("Forests")
        if 'cities' in self.widgets:
            self.widgets['cities'].label = _("Cities")


@adapter_config(name='insee',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderLocationEditForm),
                provides=IInnerSubForm)
class SearchFolderLocationAddressEditSubform(LocationAddressEditSubform):
    """Search folder location address edit form"""

    fields = field.Fields(IViewLocationSettings).select('departments', 'countries')

    def updateWidgets(self, prefix=None):
        super().updateWidgets(prefix)
        if 'departments' in self.widgets:
            self.widgets['departments'].label = _("Departments")
        if 'countries' in self.widgets:
            self.widgets['countries'].label = _("Countries")


@adapter_config(name='structure',
                context=(ISearchFolder, IPyAMSLayer, SearchFolderLocationEditForm),
                provides=IInnerSubForm)
class SearchFolderLocationStructuresEditSubform(LocationStructuresEditSubform):
    """Search folder location forests edit form"""

    fields = field.Fields(IViewLocationSettings).select('structures')

    def updateWidgets(self, prefix=None):
        super().updateWidgets(prefix)
        if 'structures' in self.widgets:
            self.widgets['structures'].label = _("Structures")
